/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.model.RestrictionMeta;

@Entity(name="org.openurp.edu.clazz.model.RestrictionItem")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class RestrictionItem
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6697398004696236934L;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.IDEnumType")
    private RestrictionMeta meta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Restriction restriction;
    private boolean included;
    @NotNull
    private String contents;

    public RestrictionItem() {
    }

    public RestrictionItem(RestrictionMeta meta, String contents, boolean included) {
        this.meta = meta;
        this.contents = contents;
        this.included = included;
    }

    public RestrictionMeta getMeta() {
        return this.meta;
    }

    public void setMeta(RestrictionMeta meta) {
        this.meta = meta;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Restriction restriction) {
        this.restriction = restriction;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public Object clone() {
        try {
            RestrictionItem clone = (RestrictionItem)super.clone();
            clone.setId(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getContentForHql() {
        if (null != this.contents && null != this.meta && RestrictionMeta.Grade.equals((Object)this.meta)) {
            this.contents = "'" + this.contents + "'";
        }
        return this.contents;
    }

    public String toString() {
        return this.contents;
    }
}

