/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.model.RestrictionItem;
import org.openurp.edu.clazz.model.RestrictionMeta;

public class RestrictionHelper {
    private static RestrictionComparator comparator = new RestrictionComparator();

    public static void autoMatches(Clazz clazz) {
        List<Restriction> groups = clazz.getEnrollment().getRestrictions();
        Collections.sort(groups, comparator);
        Map cnts = CollectUtils.newHashMap();
        for (CourseTaker taker : clazz.getEnrollment().getCourseTakers()) {
            Restriction limitGroup = RestrictionHelper.getMatchRestriction(clazz, taker.getStd());
            if (null == limitGroup) continue;
            Integer old = (Integer)cnts.get(limitGroup);
            if (null == old) {
                cnts.put(limitGroup, 1);
                continue;
            }
            cnts.put(limitGroup, old + 1);
        }
    }

    public static Restriction getMatchRestriction(Clazz clazz, Student student) {
        for (Restriction group : clazz.getEnrollment().getRestrictions()) {
            boolean groupPass = true;
            for (RestrictionItem item : group.getItems()) {
                boolean itemPass = true;
                RestrictionMeta meta = item.getMeta();
                Set values = CollectUtils.newHashSet((Object[])item.getContents().split(","));
                Object value = null;
                if (meta.equals((Object)RestrictionMeta.Squad)) {
                    value = student.getSquad() == null ? "" : "" + student.getSquad().getId();
                } else if (meta.equals((Object)RestrictionMeta.Department)) {
                    value = "" + student.getDepartment().getId();
                } else if (meta.equals((Object)RestrictionMeta.Direction)) {
                    value = student.getDirection() == null ? "" : "" + student.getDirection().getId();
                } else if (meta.equals((Object)RestrictionMeta.Level)) {
                    value = "" + student.getLevel().getId();
                } else if (meta.equals((Object)RestrictionMeta.Gender)) {
                    value = "" + student.getGender().getId();
                } else if (meta.equals((Object)RestrictionMeta.Grade)) {
                    value = student.getGrade().getCode();
                } else if (meta.equals((Object)RestrictionMeta.Major)) {
                    value = "" + student.getMajor().getId();
                } else if (meta.equals((Object)RestrictionMeta.StdType)) {
                    value = "" + student.getStdType().getId();
                } else if (meta.equals((Object)RestrictionMeta.EduType)) {
                    value = "" + student.getEduType().getId();
                }
                if (item.isIncluded()) {
                    itemPass = values.isEmpty() || values.contains(value);
                } else {
                    boolean bl = itemPass = !values.isEmpty() && !values.contains(value);
                }
                if (itemPass) continue;
                groupPass = false;
                break;
            }
            if (!groupPass) continue;
            return group;
        }
        return null;
    }

    public static RestrictionComparator getComparator() {
        return comparator;
    }

    private static class RestrictionComparator
    implements Comparator<Restriction> {
        private static final int MAXPRIORITY = 20000;
        private static final int HIGHPRIORITY = 10000;
        private static final int NORMALPRIORITY = 5000;
        private static final int LOWPRIORITY = 2500;
        private static final int ZEROPRIORITY = 500;
        private List<RestrictionMeta> restrictionMetas = CollectUtils.newArrayList((Object[])new RestrictionMeta[]{RestrictionMeta.Squad, RestrictionMeta.Direction, RestrictionMeta.Major, RestrictionMeta.Department});

        private RestrictionComparator() {
        }

        @Override
        public int compare(Restriction o1, Restriction o2) {
            int priorty2;
            int priorty1 = this.getPriority(o1);
            if (priorty1 == (priorty2 = this.getPriority(o2))) {
                return o2.getMaxCount() - o2.getCurCount() - (o1.getMaxCount() - o1.getCurCount());
            }
            return priorty2 - priorty1;
        }

        private int getPriority(Restriction group) {
            int priority = 0;
            boolean hasMax = false;
            for (RestrictionItem courseLimitItem : group.getItems()) {
                if (!courseLimitItem.isIncluded()) {
                    if (RestrictionMeta.Squad.equals((Object)courseLimitItem.getMeta())) {
                        if (hasMax) continue;
                        priority += 10000;
                        continue;
                    }
                    if (RestrictionMeta.Direction.equals((Object)courseLimitItem.getMeta())) {
                        priority += 5000;
                        continue;
                    }
                    if (RestrictionMeta.Major.equals((Object)courseLimitItem.getMeta())) {
                        priority += 2500;
                        continue;
                    }
                    if (RestrictionMeta.Department.equals((Object)courseLimitItem.getMeta())) {
                        priority += 1250;
                        continue;
                    }
                    if (this.restrictionMetas.contains((Object)courseLimitItem.getMeta())) continue;
                    priority += 250;
                    continue;
                }
                if (RestrictionMeta.Squad.equals((Object)courseLimitItem.getMeta())) {
                    if (hasMax) continue;
                    priority += 20000;
                    continue;
                }
                if (RestrictionMeta.Direction.equals((Object)courseLimitItem.getMeta())) {
                    priority += 10000;
                    continue;
                }
                if (RestrictionMeta.Major.equals((Object)courseLimitItem.getMeta())) {
                    priority += 5000;
                    continue;
                }
                if (RestrictionMeta.Department.equals((Object)courseLimitItem.getMeta())) {
                    priority += 2500;
                    continue;
                }
                if (this.restrictionMetas.contains((Object)courseLimitItem.getMeta())) continue;
                priority += 500;
            }
            return priority;
        }
    }
}

