/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.model.RestrictionItem;
import org.openurp.edu.clazz.model.RestrictionMeta;
import org.openurp.edu.clazz.service.RestrictionBuilder;
import org.openurp.edu.clazz.service.internal.DefaultTeachClassNameStrategy;

public class DefaultRestrictionBuilder
implements RestrictionBuilder {
    Restriction group = new Restriction();
    DefaultTeachClassNameStrategy strategy = new DefaultTeachClassNameStrategy();

    public DefaultRestrictionBuilder() {
    }

    public DefaultRestrictionBuilder(Restriction group) {
        this.group = group;
    }

    @Override
    public RestrictionBuilder inGrades(String ... grades) {
        if (grades.length > 0 && grades[0] != null) {
            RestrictionItem item = this.getOrCreateItem(RestrictionMeta.Grade);
            this.addValues(item, true, grades);
        }
        return this;
    }

    @Override
    public RestrictionBuilder notInGrades(String ... grades) {
        RestrictionItem item = this.getOrCreateItem(RestrictionMeta.Grade);
        this.addValues(item, false, grades);
        return this;
    }

    @Override
    public <T extends Entity<?>> RestrictionBuilder in(T ... entities) {
        if (entities.length > 0 && entities[0] != null) {
            T first = entities[0];
            RestrictionItem item = this.getItem(first);
            this.addValues(item, true, this.getIds((Entity<?>[])entities));
        }
        if (entities.length > 0 && entities[0] instanceof Squad) {
            this.clear(RestrictionMeta.Grade);
            this.clear(RestrictionMeta.StdType);
            this.clear(RestrictionMeta.Department);
            this.clear(RestrictionMeta.Major);
            this.clear(RestrictionMeta.Direction);
            this.clear(RestrictionMeta.Level);
        }
        return this;
    }

    @Override
    public <T extends Entity<?>> RestrictionBuilder notIn(T ... entities) {
        if (entities.length >= 0 && entities[0] != null) {
            T first = entities[0];
            RestrictionItem item = this.getItem(first);
            this.addValues(item, false, this.getIds((Entity<?>[])entities));
        }
        return this;
    }

    @Override
    public RestrictionBuilder clear(RestrictionMeta meta) {
        RestrictionItem removed = null;
        for (RestrictionItem item : this.group.getItems()) {
            if (!item.getMeta().equals((Object)meta)) continue;
            removed = item;
        }
        if (null != removed) {
            this.group.getItems().remove(removed);
        }
        return this;
    }

    @Override
    public Restriction build() {
        return this.group;
    }

    private String[] getIds(Entity<?> ... entities) {
        String[] ids = new String[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            ids[i] = String.valueOf(entities[i].getId());
        }
        return ids;
    }

    private void addValues(RestrictionItem item, boolean contain, String ... values) {
        Object old = item.getContents();
        old = ((String)old).length() > 0 ? Strings.concat((String[])new String[]{old, ",", Strings.join((String[])values, (String)",")}) : Strings.join((String[])values, (String)",");
        if (-1 != ((String)old).indexOf(44)) {
            if (!((String)old).startsWith(",")) {
                old = "," + (String)old;
            }
            if (!((String)old).endsWith(",")) {
                old = (String)old + ",";
            }
        }
        item.setContents((String)old);
        item.setIncluded(contain);
    }

    private RestrictionItem getOrCreateItem(RestrictionMeta meta) {
        for (RestrictionItem item : this.group.getItems()) {
            if (!item.getMeta().equals((Object)meta)) continue;
            return item;
        }
        RestrictionItem item = new RestrictionItem();
        item.setMeta(meta);
        item.setIncluded(true);
        item.setContents("");
        item.setRestriction(this.group);
        this.group.getItems().add(item);
        return item;
    }

    private <T> RestrictionItem getItem(T first) {
        RestrictionItem item = null;
        if (first instanceof Gender) {
            item = this.getOrCreateItem(RestrictionMeta.Gender);
        } else if (first instanceof StdType) {
            item = this.getOrCreateItem(RestrictionMeta.StdType);
        } else if (first instanceof Department) {
            item = this.getOrCreateItem(RestrictionMeta.Department);
        } else if (first instanceof Major) {
            item = this.getOrCreateItem(RestrictionMeta.Major);
        } else if (first instanceof Direction) {
            item = this.getOrCreateItem(RestrictionMeta.Direction);
        } else if (first instanceof Squad) {
            item = this.getOrCreateItem(RestrictionMeta.Squad);
        } else if (first instanceof EducationLevel) {
            item = this.getOrCreateItem(RestrictionMeta.Level);
        } else {
            throw new RuntimeException("no support limit meta class " + first.getClass().getName());
        }
        return item;
    }
}

