/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.limit.impl;

import java.util.Date;
import java.util.Map;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Direction;
import org.openurp.edu.clazz.model.RestrictionMeta;
import org.openurp.edu.clazz.service.limit.impl.AbstractCourseLimitEntityProvider;

public class CourseLimitDirectionProvider
extends AbstractCourseLimitEntityProvider<Direction> {
    @Override
    protected void addCascadeQuery(OqlBuilder<Direction> builder, Map<RestrictionMeta, String> cascadeField) {
        builder.where("entity.project = :project", (Object)this.projectContext.getProject());
        if (cascadeField.isEmpty()) {
            return;
        }
        String majorIds = cascadeField.get((Object)RestrictionMeta.Major);
        String departIds = cascadeField.get((Object)RestrictionMeta.Department);
        String levelIds = cascadeField.get((Object)RestrictionMeta.Level);
        if (Strings.isNotBlank((CharSequence)majorIds)) {
            builder.where("entity.major.id in (:majorIds)", (Object)Strings.splitToLong((String)majorIds));
        }
        if (Strings.isNotBlank((CharSequence)departIds) || Strings.isNotBlank((CharSequence)levelIds)) {
            StringBuilder sb = new StringBuilder("exists(from entity.departs journal where journal.beginOn <= :now and (journal.endOn is null or journal.endOn >= :now)");
            if (Strings.isNotBlank((CharSequence)departIds)) {
                sb.append(" and journal.depart.id in (:departIds)");
            }
            if (Strings.isNotBlank((CharSequence)levelIds)) {
                sb.append(" and journal.level.id in (:levelIds)");
            }
            sb.append(")");
            builder.where(sb.toString(), (Object)new Date(), (Object)(Strings.isBlank((CharSequence)departIds) ? null : Strings.splitToInt((String)departIds)), (Object)(Strings.isBlank((CharSequence)levelIds) ? null : Strings.splitToInt((String)levelIds)), new Object[0]);
        }
    }

    @Override
    public RestrictionMeta getMeta() {
        return RestrictionMeta.Direction;
    }
}

