/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.beangle.commons.dao.EntityDao;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.model.ExamGradeState;
import org.openurp.edu.grade.course.model.GradeState;
import org.openurp.edu.grade.course.service.GradingModeStrategy;

public class DefaultGradingModeStrategy
implements GradingModeStrategy {
    private EntityDao entityDao;

    private boolean isDefault(GradingMode style) {
        return null == style || ((Integer)style.getId()).equals(GradingMode.Percent);
    }

    @Override
    public final void configGradingMode(CourseGradeState gradeState, List<GradeType> gradeTypes) {
        if (this.isDefault(gradeState.getGradingMode())) {
            gradeState.setGradingMode(this.getDefaultCourseGradeGradingMode(gradeState));
        }
        for (GradeType type : gradeTypes) {
            GradeState typeState = this.getState(gradeState, type);
            if (null != typeState.getGradingMode()) continue;
            typeState.setGradingMode(this.getDefaultExamGradeGradingMode(gradeState, typeState));
        }
        this.entityDao.saveOrUpdate(new Object[]{gradeState});
    }

    protected GradingMode getDefaultCourseGradeGradingMode(CourseGradeState state) {
        Set<GradingMode> modes = state.getClazz().getCourse().getGradingModes();
        if (modes.isEmpty()) {
            return (GradingMode)this.entityDao.get(GradingMode.class, (Serializable)GradingMode.Percent);
        }
        return (GradingMode)((Object)modes.iterator().next());
    }

    protected GradingMode getDefaultExamGradeGradingMode(CourseGradeState gradeState, GradeState typeState) {
        if (typeState.getGradeType().isGa()) {
            return gradeState.getGradingMode();
        }
        if (((Integer)typeState.getGradeType().getId()).equals(GradeType.DELAY_ID)) {
            ExamGradeState endGradeState = (ExamGradeState)gradeState.getState(new GradeType(GradeType.END_ID));
            if (null == endGradeState) {
                return gradeState.getGradingMode();
            }
            return endGradeState.getGradingMode();
        }
        return (GradingMode)this.entityDao.get(GradingMode.class, (Serializable)GradingMode.Percent);
    }

    private GradeState getState(CourseGradeState gradeState, GradeType gradeType) {
        return gradeState.getOrCreateState(gradeType);
    }

    public final void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

