/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.plan.model.PlanAuditResult;
import org.openurp.edu.grade.plan.service.AbstractJob;
import org.openurp.edu.grade.plan.service.PlanAuditService;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserverStack;
import org.openurp.edu.grade.plan.service.observers.PlanAuditPersistObserver;

public class AutoBatchAuditor
extends AbstractJob {
    private PlanAuditService planAuditService;
    private PlanAuditPersistObserver planAuditPersistObserver;
    private int bulkSize = 15;

    @Override
    protected void doExecute() {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"s");
        query.where("not exists(from " + PlanAuditResult.class.getName() + " r where r.std=s and r.updatedAt > :updatedAt)", (Object)java.sql.Date.valueOf(LocalDate.now()));
        query.where("s.state.inschool=true");
        query.where("s.beginOn <= :now and s.endOn >= :now and s.registed = true", (Object)new Date());
        query.orderBy("s.code");
        query.limit(1, this.bulkSize);
        List stds = this.entityDao.search((QueryBuilder)query);
        long startAt = System.currentTimeMillis();
        this.logger.info("start auto gew ...");
        PlanAuditObserverStack observerStack = new PlanAuditObserverStack(this.planAuditPersistObserver);
        this.planAuditService.batchAudit(stds, null, observerStack, null);
        if (stds.size() > 0) {
            this.logger.info("auto gew: " + ((Student)stds.get(0)).getCode() + "~" + ((Student)stds.get(stds.size() - 1)).getCode() + "[" + stds.size() + "] using " + (double)(System.currentTimeMillis() - startAt) / 1000.0 + "s");
        } else {
            this.logger.info("auto gew: all result is updated today!");
        }
    }

    public int getBulkSize() {
        return this.bulkSize;
    }

    public void setBulkSize(int bulkSize) {
        this.bulkSize = bulkSize;
    }

    public void setPlanAuditService(PlanAuditService planAuditService) {
        this.planAuditService = planAuditService;
    }

    public void setPlanAuditPersistObserver(PlanAuditPersistObserver planAuditPersistObserver) {
        this.planAuditPersistObserver = planAuditPersistObserver;
    }
}

