/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.internal;

import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.internal.GroupResultBuilder;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.utils.PlanUtils;

public class DefaultGroupResultBuilder
implements GroupResultBuilder {
    @Override
    public GroupAuditResult buildResult(PlanAuditContext context, CourseGroup group) {
        GroupAuditResult result = new GroupAuditResult();
        float requiredCredits = group.getCredits();
        if (context.getAuditTerms() != null && context.getAuditTerms().length != 0) {
            requiredCredits = 0.0f;
            float groupCourseCredits = 0.0f;
            boolean creditsNeedCompare = false;
            Set auditedCourses = CollectUtils.newHashSet();
            for (int i = 0; i < context.getAuditTerms().length; ++i) {
                int term = Integer.valueOf(context.getAuditTerms()[i]);
                requiredCredits += PlanUtils.getGroupCredits(group, term);
                if (!group.getChildren().isEmpty() || group.getPlanCourses().isEmpty() || !group.isAutoAddup()) continue;
                creditsNeedCompare = true;
                for (PlanCourse planCourse : group.getPlanCourses()) {
                    if (auditedCourses.contains(planCourse.getCourse()) || !planCourse.getTerms().contains(term)) continue;
                    groupCourseCredits += planCourse.getCourse().getDefaultCredits();
                    auditedCourses.add(planCourse.getCourse());
                }
            }
            if (creditsNeedCompare) {
                requiredCredits = Float.compare(requiredCredits, groupCourseCredits) < 0 ? requiredCredits : groupCourseCredits;
            }
        }
        result.getAuditStat().setRequiredCredits(requiredCredits);
        if (context.isPartial()) {
            result.getAuditStat().setRequiredCount(0);
        } else {
            result.getAuditStat().setRequiredCount(group.getCourseCount());
        }
        result.setCourseType(group.getCourseType());
        result.setName(group.getName());
        result.setSubCount(group.getSubCount());
        result.setIndexno(group.getIndexno());
        result.setPlanResult(context.getResult());
        return result;
    }
}

