/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.base.service.SemesterService;
import org.openurp.base.util.TermCalculator;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.app.model.AuditSetting;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.plan.model.CourseAuditResult;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.model.PlanAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.PlanAuditListener;
import org.openurp.edu.grade.plan.service.StdGrade;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;

public class PlanAuditCourseTypeMatchListener
implements PlanAuditListener {
    private SemesterService semesterService;

    protected void addGroupResult(Map<CourseType, GroupAuditResult> results, GroupAuditResult gr) {
        results.put(gr.getCourseType(), gr);
        for (GroupAuditResult child : gr.getChildren()) {
            this.addGroupResult(results, child);
        }
    }

    @Override
    public void endPlanAudit(PlanAuditContext context) {
        String[] auditTerms = context.getAuditTerms();
        Map results = CollectUtils.newHashMap();
        StdGrade stdGrade = context.getStdGrade();
        Collection<Course> restCourses = stdGrade.getRestCourses();
        if (!restCourses.isEmpty()) {
            PlanAuditResult result = context.getResult();
            for (GroupAuditResult gr : result.getGroupResults()) {
                this.addGroupResult(results, gr);
            }
        }
        for (Course course : restCourses) {
            CourseGroup g;
            GroupAuditResult groupResult;
            List<CourseGrade> grades = stdGrade.getGrades(course);
            CourseType courseType = null;
            if (grades.isEmpty() || null == (groupResult = (GroupAuditResult)((Object)results.get((Object)(courseType = grades.get(0).getCourseType())))) || null != (g = context.getCoursePlan().getGroup(groupResult.getCourseType())) && !g.getCourseType().isOptional()) continue;
            stdGrade.useGrades(course);
            StringBuilder remark = new StringBuilder();
            if (null != auditTerms && auditTerms.length > 0 && context.getCoursePlan() != null) {
                boolean inAuditTerms = false;
                block2: for (CourseGrade grade : grades) {
                    if (inAuditTerms) break;
                    int term = -1;
                    term = context.getCoursePlan().getEndOn() != null ? new TermCalculator(this.semesterService, grade.getSemester()).getTerm(context.getCoursePlan().getEndOn(), context.getCoursePlan().getEndOn(), true) : new TermCalculator(this.semesterService, grade.getSemester()).getTerm(context.getCoursePlan().getBeginOn(), Date.valueOf("2099-09-09"), true);
                    for (int j = 0; j < auditTerms.length; ++j) {
                        if (!String.valueOf(term).equals(auditTerms[j])) continue;
                        inAuditTerms = true;
                        continue block2;
                    }
                }
                if (!inAuditTerms) continue;
            }
            CourseGroup courseGroup = context.getCoursePlan().getGroup(courseType);
            boolean outOfPlan = false;
            if (null == courseGroup || !CollectUtils.isEmpty(courseGroup.getPlanCourses())) {
                outOfPlan = true;
            }
            CourseAuditResult existResult = null;
            boolean existed = false;
            for (CourseAuditResult cr : groupResult.getCourseResults()) {
                if (!cr.getCourse().equals(course)) continue;
                existResult = cr;
                existed = true;
                break;
            }
            if (existResult == null) {
                existResult = new CourseAuditResult();
            }
            existResult.setCourse(course);
            existResult.checkPassed(grades);
            groupResult.updateCourseResult(existResult);
            if (null != existResult.getRemark()) {
                remark.insert(0, existResult.getRemark());
            }
            if (outOfPlan) {
                remark.append(" \u8ba1\u5212\u5916");
            }
            existResult.setRemark(remark.toString());
            if (!existed) {
                groupResult.addCourseResult(existResult);
            }
            groupResult.checkPassed(true);
        }
    }

    @Override
    public boolean startCourseAudit(PlanAuditContext context, GroupAuditResult groupResult, PlanCourse planCourse) {
        return true;
    }

    @Override
    public boolean startGroupAudit(PlanAuditContext context, CourseGroup courseGroup, GroupAuditResult groupResult) {
        AuditSetting standard = context.getSetting();
        if (null != standard) {
            return !standard.isDisaudit(courseGroup.getCourseType());
        }
        return true;
    }

    @Override
    public boolean startPlanAudit(PlanAuditContext context) {
        return true;
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }
}

