/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.plan.model.CourseAuditResult;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.PlanAuditListener;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExemptCourse;
import org.openurp.edu.program.model.PlanCourse;

public class PlanAuditExemptCourseListener
implements PlanAuditListener {
    private String exemptCourseKey = "exemptCourses";
    private EntityDao entityDao;

    @Override
    public boolean startPlanAudit(PlanAuditContext context) {
        Student std = context.getResult().getStd();
        OqlBuilder query = OqlBuilder.from(ExemptCourse.class, (String)"ec");
        query.where("ec.fromGrade.code<=:gradeCode", (Object)std.getGrade().getCode());
        List ecs = this.entityDao.search((QueryBuilder)query);
        HashSet<Course> exemptCourses = new HashSet<Course>();
        for (ExemptCourse ec : ecs) {
            if (!ec.getStdTypes().contains((Object)std.getStdType()) || null != ec.getToGrade() && ec.getToGrade().getCode().compareTo(std.getGrade().getCode()) < 0) continue;
            exemptCourses.add(ec.getCourse());
        }
        context.getParams().put(this.exemptCourseKey, exemptCourses);
        return true;
    }

    @Override
    public boolean startCourseAudit(PlanAuditContext context, GroupAuditResult groupResult, PlanCourse planCourse) {
        return true;
    }

    @Override
    public boolean startGroupAudit(PlanAuditContext context, CourseGroup courseGroup, GroupAuditResult groupResult) {
        return true;
    }

    @Override
    public void endPlanAudit(PlanAuditContext context) {
        Set exemptCourses = (Set)context.getParams().get(this.exemptCourseKey);
        if (exemptCourses.isEmpty()) {
            return;
        }
        for (GroupAuditResult groupResult : context.getResult().getGroupResults()) {
            HashMap<Course, CourseAuditResult> results = new HashMap<Course, CourseAuditResult>();
            for (CourseAuditResult car : groupResult.getCourseResults()) {
                results.put(car.getCourse(), car);
            }
            for (CourseAuditResult car : groupResult.getCourseResults()) {
                if (car.isPassed() || !exemptCourses.contains(car.getCourse())) continue;
                car.setScores("\u514d\u4fee");
                car.setPassed(true);
                groupResult.updateCourseResult(car);
                groupResult.checkPassed(true);
            }
        }
    }

    public EntityDao getEntityDao() {
        return this.entityDao;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

