/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.observers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.plan.adapters.GroupResultAdapter;
import org.openurp.edu.grade.plan.model.CourseAuditResult;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.model.PlanAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserver;

public class PlanAuditPersistObserver
extends BaseServiceImpl
implements PlanAuditObserver {
    @Override
    public void notifyStart() {
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean notifyBegin(PlanAuditContext context, int index) {
        return true;
    }

    private PlanAuditResult getResult(Student std) {
        OqlBuilder query = OqlBuilder.from(PlanAuditResult.class, (String)"planResult");
        query.where("planResult.std = :std", (Object)std);
        List results = this.entityDao.search((QueryBuilder)query);
        if (results.size() > 0) {
            return (PlanAuditResult)((Object)results.get(0));
        }
        return null;
    }

    @Override
    public void notifyEnd(PlanAuditContext context, int index) {
        PlanAuditResult newResult = context.getResult();
        PlanAuditResult existedResult = this.getResult(context.getStd());
        if (null != existedResult) {
            existedResult.setRemark(newResult.getRemark());
            existedResult.setUpdatedAt(new Date());
            existedResult.setAuditStat(newResult.getAuditStat());
            StringBuilder updates = new StringBuilder();
            this.mergeGroupResult(existedResult, new GroupResultAdapter(existedResult), new GroupResultAdapter(newResult), updates);
            existedResult.setPassed(newResult.isPassed());
            if (updates.length() > 0) {
                updates.deleteCharAt(updates.length() - 1);
            }
            existedResult.setUpdates(updates.toString());
        } else {
            existedResult = newResult;
        }
        this.entityDao.saveOrUpdate(new Object[]{existedResult});
        context.setResult(existedResult);
    }

    private void mergeGroupResult(PlanAuditResult existedResult, GroupAuditResult target, GroupAuditResult source, StringBuilder updates) {
        float delta = source.getAuditStat().getPassedCredits() - target.getAuditStat().getPassedCredits();
        if (Float.compare(delta, 0.0f) != 0) {
            updates.append(source.getName());
            if (delta > 0.0f) {
                updates.append('+').append(delta);
            } else {
                updates.append(delta);
            }
            updates.append(';');
        }
        target.setAuditStat(source.getAuditStat());
        target.setPassed(source.isPassed());
        target.setIndexno(source.getIndexno());
        Map targetGroupResults = CollectUtils.newHashMap();
        Map sourceGroupResults = CollectUtils.newHashMap();
        for (GroupAuditResult result : target.getChildren()) {
            targetGroupResults.put(result.getName(), result);
        }
        for (GroupAuditResult result : source.getChildren()) {
            sourceGroupResults.put(result.getName(), result);
        }
        Map targetCourseResults = CollectUtils.newHashMap();
        Map sourceCourseResults = CollectUtils.newHashMap();
        for (CourseAuditResult courseAuditResult : target.getCourseResults()) {
            targetCourseResults.put(courseAuditResult.getCourse(), courseAuditResult);
        }
        for (CourseAuditResult courseAuditResult : source.getCourseResults()) {
            sourceCourseResults.put(courseAuditResult.getCourse(), courseAuditResult);
        }
        Set removed = CollectUtils.subtract(targetGroupResults.keySet(), sourceGroupResults.keySet());
        for (Object groupName : removed) {
            GroupAuditResult gg = (GroupAuditResult)((Object)targetGroupResults.get(groupName));
            gg.detach();
            target.removeChild(gg);
        }
        Set set = CollectUtils.subtract(sourceGroupResults.keySet(), targetGroupResults.keySet());
        for (Object groupName : set) {
            GroupAuditResult groupResult = (GroupAuditResult)((Object)sourceGroupResults.get(groupName));
            target.addChild(groupResult);
            groupResult.attachTo(existedResult);
        }
        Set common = CollectUtils.intersection(sourceGroupResults.keySet(), targetGroupResults.keySet());
        for (Object groupName : common) {
            this.mergeGroupResult(existedResult, (GroupAuditResult)((Object)targetGroupResults.get(groupName)), (GroupAuditResult)((Object)sourceGroupResults.get(groupName)), updates);
        }
        Set removedCourses = CollectUtils.subtract(targetCourseResults.keySet(), sourceCourseResults.keySet());
        for (Object course : removedCourses) {
            CourseAuditResult courseResult = (CourseAuditResult)((Object)targetCourseResults.get(course));
            target.getCourseResults().remove((Object)courseResult);
        }
        Set addedCourses = CollectUtils.subtract(sourceCourseResults.keySet(), targetCourseResults.keySet());
        for (Course course : addedCourses) {
            CourseAuditResult courseResult = (CourseAuditResult)((Object)sourceCourseResults.get(course));
            courseResult.getGroupResult().getCourseResults().remove((Object)courseResult);
            courseResult.setGroupResult(target);
            target.getCourseResults().add(courseResult);
        }
        Set commonCourses = CollectUtils.intersection(sourceCourseResults.keySet(), targetCourseResults.keySet());
        for (Course course : commonCourses) {
            CourseAuditResult targetCourseResult = (CourseAuditResult)((Object)targetCourseResults.get(course));
            CourseAuditResult sourceCourseResult = (CourseAuditResult)((Object)sourceCourseResults.get(course));
            targetCourseResult.setPassed(sourceCourseResult.isPassed());
            targetCourseResult.setScores(sourceCourseResult.getScores());
            targetCourseResult.setCompulsory(sourceCourseResult.isCompulsory());
            targetCourseResult.setRemark(sourceCourseResult.getRemark());
        }
    }
}

