/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.dao.hibernate;

import java.util.Date;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.model.User;
import org.openurp.edu.program.app.dao.ExecutionPlanCourseGroupModifyAuditDao;
import org.openurp.edu.program.app.model.ExecutionCourseGroupModify;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.ExecutionPlanAuditException;

public class ExecutionPlanCourseGroupModifyAuditDaoHibernate
extends HibernateEntityDao
implements ExecutionPlanCourseGroupModifyAuditDao {
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void rejected(ExecutionCourseGroupModify apply, User assessor) {
        apply.setAssessor(assessor);
        apply.setFlag(ExecutionCourseGroupModify.REFUSE);
        apply.setReplyDate(new Date());
        this.saveOrUpdate(new Object[]{apply});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void approved(ExecutionCourseGroupModify apply, User assessor) throws ExecutionPlanAuditException {
        ExecutionPlan plan = (ExecutionPlan)this.get(ExecutionPlan.class, apply.getExecutionPlan().getId());
        if (plan == null) {
            throw new ExecutionPlanAuditException("\u60a8\u8981\u4fee\u6539\u7684\u4e13\u4e1a\u57f9\u517b\u8ba1\u5212\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002");
        }
        ExecutionCourseGroup parent = null;
        if (apply.getNewPlanCourseGroup() != null && apply.getNewPlanCourseGroup().getParent() != null && null == (parent = (ExecutionCourseGroup)this.get(ExecutionCourseGroup.class, apply.getNewPlanCourseGroup().getParent().getId()))) {
            throw new ExecutionPlanAuditException("\u7236\u8bfe\u7a0b\u7ec4\u5df2\u4e0d\u5b58\u5728");
        }
        ExecutionCourseGroup courseGroup = new ExecutionCourseGroup();
        if (ExecutionCourseGroupModify.DELETE.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getOldPlanCourseGroup().getCourseType().getId();
            ExecutionCourseGroup group = (ExecutionCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (group == null) throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728:" + apply.getOldPlanCourseGroup().getCourseType().getName());
            this.planCourseGroupCommonDao.removeCourseGroup(group);
        } else if (ExecutionCourseGroupModify.ADD.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getNewPlanCourseGroup().getCourseType().getId();
            ExecutionCourseGroup group = (ExecutionCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (group != null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u7ec4\u5df2\u5b58\u5728:" + apply.getNewPlanCourseGroup().getCourseType().getName());
            }
            group = new ExecutionCourseGroup();
            group.setPlan(plan);
            group.setCourseType(apply.getNewPlanCourseGroup().getCourseType());
            group.setCourseCount(apply.getNewPlanCourseGroup().getCourseCount());
            group.setTermCredits(apply.getNewPlanCourseGroup().getTermCredits());
            group.setCredits(apply.getNewPlanCourseGroup().getCredits());
            group.setSubCount(apply.getNewPlanCourseGroup().getSubCount());
            group.setRemark(apply.getNewPlanCourseGroup().getRemark());
            group.setIndexno("--");
            this.planCourseGroupCommonDao.addCourseGroupToPlan(group, parent, plan);
        } else if (ExecutionCourseGroupModify.MODIFY.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getOldPlanCourseGroup().getCourseType().getId();
            ExecutionCourseGroup oldGroup = (ExecutionCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (oldGroup == null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728:" + apply.getOldPlanCourseGroup().getCourseType().getName());
            }
            this.planCourseGroupCommonDao.updateCourseGroupParent(oldGroup, parent, plan);
            oldGroup.setCourseType(apply.getNewPlanCourseGroup().getCourseType());
            oldGroup.setCourseCount(apply.getNewPlanCourseGroup().getCourseCount());
            oldGroup.setTermCredits(apply.getNewPlanCourseGroup().getTermCredits());
            oldGroup.setCredits(apply.getNewPlanCourseGroup().getCredits());
            oldGroup.setSubCount(apply.getNewPlanCourseGroup().getSubCount());
            oldGroup.setRemark(apply.getNewPlanCourseGroup().getRemark());
            this.planCourseGroupCommonDao.saveOrUpdateCourseGroup(oldGroup);
            this.saveOrUpdate(new Object[]{plan});
        }
        apply.setAssessor(assessor);
        apply.setFlag(ExecutionCourseGroupModify.ACCEPT);
        apply.setReplyDate(new Date());
        this.saveOrUpdate(new Object[]{apply});
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

