/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.app.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.ElectionMode;
import org.openurp.edu.clazz.app.model.enums.ElectRuleType;
import org.openurp.edu.clazz.model.CourseTaker;

@Entity(name="org.openurp.edu.clazz.app.model.ElectLogger")
public class ElectLogger
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = 1L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    private String crn;
    @NotNull
    private String courseType;
    @NotNull
    private String courseCode;
    @NotNull
    private String courseName;
    private float credits;
    private Integer turn;
    @NotNull
    private String stdCode;
    @NotNull
    private String stdName;
    @NotNull
    private String operatorCode;
    @NotNull
    private String operatorName;
    @NotNull
    private String ipAddress;
    @NotNull
    private ElectRuleType type;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseTakeType courseTakeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ElectionMode electionMode;

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public String getClazzNo() {
        return this.crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public String getCourseType() {
        return this.courseType;
    }

    public void setCourseType(String courseType) {
        this.courseType = courseType;
    }

    public String getCourseCode() {
        return this.courseCode;
    }

    public void setCourseCode(String courseCode) {
        this.courseCode = courseCode;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public float getCredits() {
        return this.credits;
    }

    public void setCredits(float credits) {
        this.credits = credits;
    }

    public Integer getTurn() {
        return this.turn;
    }

    public void setTurn(Integer turn) {
        this.turn = turn;
    }

    public String getStdCode() {
        return this.stdCode;
    }

    public void setStdCode(String stdCode) {
        this.stdCode = stdCode;
    }

    public String getStdName() {
        return this.stdName;
    }

    public void setStdName(String stdName) {
        this.stdName = stdName;
    }

    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ElectRuleType getType() {
        return this.type;
    }

    public void setType(ElectRuleType type) {
        this.type = type;
    }

    public CourseTakeType getCourseTakeType() {
        return this.courseTakeType;
    }

    public void setCourseTakeType(CourseTakeType courseTakeType) {
        this.courseTakeType = courseTakeType;
    }

    public void setLoggerData(CourseTaker courseTaker) {
        Course course = courseTaker.getClazz().getCourse();
        this.setProject(courseTaker.getClazz().getProject());
        this.setCourseCode(course.getCode());
        this.setCourseName(course.getName());
        this.setCourseTakeType(courseTaker.getTakeType());
        this.setCourseType(courseTaker.getClazz().getCourseType().getName());
        this.setCredits(course.getDefaultCredits());
        this.setCrn(courseTaker.getClazz().getCrn());
        this.setStdCode(courseTaker.getStd().getCode());
        this.setStdName(courseTaker.getStd().getName());
        this.setSemester(courseTaker.getClazz().getSemester());
    }

    public void setElectionMode(ElectionMode electionMode) {
        this.electionMode = electionMode;
    }

    public ElectionMode getElectionMode() {
        return this.electionMode;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

