/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Squad;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.service.ClazzPlanRelationService;
import org.openurp.edu.clazz.service.CourseLimitService;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.plan.service.ExecutionPlanQueryBuilder;

public class ClazzPlanRelationServiceImpl
extends BaseServiceImpl
implements ClazzPlanRelationService {
    private CourseLimitService courseLimitService;
    private EntityDao entityDao;

    @Override
    public List<Clazz> relatedClazzes(ExecutionPlan plan) {
        OqlBuilder query = OqlBuilder.from(Clazz.class, (String)"clazz");
        query.where("clazz.planId = :planId", (Object)plan.getId());
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<Clazz> relatedClazzes(ExecutionPlan plan, Semester semester) {
        OqlBuilder query = OqlBuilder.from(Clazz.class, (String)"clazz");
        query.where("clazz.planId = :planId", (Object)plan.getId());
        query.where("clazz.semester=:semester", (Object)semester);
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<ExecutionPlan> possibleRelatePlans(Clazz clazz) {
        List<Direction> directions;
        ArrayList<ExecutionPlan> plans = new ArrayList<ExecutionPlan>();
        List<Squad> squades = this.courseLimitService.extractSquades(clazz.getEnrollment());
        if (CollectUtils.isNotEmpty(squades)) {
            for (Squad squad : squades) {
                plans.addAll(this.entityDao.search(ExecutionPlanQueryBuilder.build(squad)));
            }
            return plans;
        }
        String grade = this.courseLimitService.extractGrade(clazz.getEnrollment());
        if (Strings.isEmpty((CharSequence)grade)) {
            return CollectUtils.newArrayList();
        }
        List<Major> majors = this.courseLimitService.extractMajors(clazz.getEnrollment());
        if (CollectUtils.isEmpty(majors)) {
            return CollectUtils.newArrayList();
        }
        List<StdType> stdTypes = this.courseLimitService.extractStdTypes(clazz.getEnrollment());
        if (CollectUtils.isEmpty(stdTypes)) {
            stdTypes.add(null);
        }
        if (CollectUtils.isEmpty(directions = this.courseLimitService.extractDirections(clazz.getEnrollment()))) {
            directions.add(null);
        }
        for (Major major : majors) {
            for (StdType stdType : stdTypes) {
                for (Direction direction : directions) {
                    plans.addAll(this.entityDao.search(ExecutionPlanQueryBuilder.build(grade, stdType, major, direction)));
                }
            }
        }
        return plans;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

