/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.beangle.orm.hibernate.udt.WeekState;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.WeekTimeBuilder;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.Department;
import org.openurp.base.resource.model.Classroom;
import org.openurp.code.edu.model.ActivityType;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.ElectionMode;
import org.openurp.edu.clazz.dao.ClazzDao;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.clazz.service.ClazzFilterStrategy;
import org.openurp.edu.clazz.service.ClazzLogBuilder;
import org.openurp.edu.clazz.service.ClazzLogHelper;
import org.openurp.edu.clazz.service.ClazzService;
import org.openurp.edu.clazz.service.CourseLimitUtils;
import org.openurp.edu.clazz.service.TaskCopyParams;
import org.openurp.edu.clazz.util.ClazzElectionUtil;
import org.openurp.edu.room.model.Occupancy;
import org.openurp.edu.room.model.RoomOccupyApp;

public class ClazzServiceImpl
extends BaseServiceImpl
implements ClazzService {
    private ClazzDao clazzDao;
    private ClazzLogHelper clazzLogHelper;

    @Override
    public List<Department> teachDepartsOfSemester(List<Project> projects, List<Department> departments, Semester semester) {
        if (CollectUtils.isNotEmpty(projects) && CollectUtils.isNotEmpty(departments)) {
            OqlBuilder query = OqlBuilder.from((String)(Clazz.class.getName() + " clazz"));
            query.select("distinct(clazz.teachDepart)");
            query.where(" clazz.semester=:semester and clazz.teachDepart in (:departments) and clazz.project in (:projects) ", (Object)semester, departments, projects, new Object[0]);
            return this.entityDao.search((QueryBuilder)query);
        }
        return CollectUtils.newArrayList((int)0);
    }

    @Override
    public List<CourseType> courseTypesOfSemester(List<Project> projects, List<Department> departments, Semester semester) {
        if (CollectUtils.isNotEmpty(projects) && CollectUtils.isNotEmpty(departments)) {
            OqlBuilder query = OqlBuilder.from((String)(Clazz.class.getName() + " clazz"));
            query.select("distinct(clazz.courseType)");
            query.where(" clazz.semester=:semester and clazz.teachDepart in (:departments) and clazz.project in (:projects) ", (Object)semester, departments, projects, new Object[0]);
            return this.entityDao.search((QueryBuilder)query);
        }
        return CollectUtils.newArrayList((int)0);
    }

    @Override
    public List<Department> attendDepartsOfSemester(List<Project> projects, Semester semester) {
        if (CollectUtils.isNotEmpty(projects)) {
            OqlBuilder qq = OqlBuilder.from((String)(Clazz.class.getName() + " clazz"));
            qq.join("clazz.enrollment.limitGroups", "lgroup").join("lgroup.items", "litem").where("litem.meta = :meta", (Object)ClazzRestrictionMeta.Department).where("clazz.semester = :semester", (Object)semester).where("clazz.project in (:projects)", projects);
            qq.select("litem").cacheable();
            List limitItems = this.entityDao.search((QueryBuilder)qq);
            StringBuilder sb = new StringBuilder();
            for (ClazzRestrictionItem item : limitItems) {
                String[] ids = item.getContents().split(",");
                sb.append(Strings.join((String[])ids, (String)",")).append(',');
            }
            Object[] departmentIds = Strings.splitToInt((String)sb.toString());
            ArrayList<Object> distinctIds = new ArrayList<Object>();
            Arrays.sort(departmentIds);
            Object prev = -1;
            for (int i = 0; i < departmentIds.length; ++i) {
                if (!((Integer)prev).equals(departmentIds[i])) {
                    distinctIds.add(departmentIds[i]);
                }
                prev = departmentIds[i];
            }
            if (CollectUtils.isEmpty(distinctIds)) {
                return new ArrayList<Department>();
            }
            return this.entityDao.get(Department.class, distinctIds);
        }
        return CollectUtils.newArrayList((int)0);
    }

    @Override
    public List<Department> canAttendDepartsOfSemester(List<Project> projects, List<Department> departments, Semester semester) {
        if (CollectUtils.isNotEmpty(projects) && CollectUtils.isNotEmpty(departments)) {
            OqlBuilder query = OqlBuilder.from(Department.class, (String)"department");
            query.where("exists (from org.openurp.edu.program.model.ExecutionPlan plan where plan.program.department=department and plan.program.major.project in (:projects) and plan.program.department in (:departs) and current_date() >= plan.program.beginOn and (plan.program.endOn is null or current_date() <= plan.program.endOn))", (Object)semester, departments, projects, new Object[0]);
            return this.entityDao.search((QueryBuilder)query);
        }
        return CollectUtils.newArrayList((int)0);
    }

    @Override
    public List<Project> getProjectsForTeacher(Teacher teacher) {
        OqlBuilder query = OqlBuilder.from(Clazz.class, (String)"clazz").select("clazz.project").join("clazz.teachers", "teacher").where("teacher = :teacher", (Object)teacher);
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<Clazz> getClazzByCategory(Serializable id, ClazzFilterStrategy strategy, Collection<Semester> semesters) {
        if (null == id || semesters.isEmpty()) {
            return CollectUtils.newArrayList((int)0);
        }
        String prefix = "select distinct clazz.id from org.openurp.edu.clazz.model.Clazz as clazz ";
        String postfix = " and clazz.semester in (:semesters) ";
        OqlBuilder query = OqlBuilder.hql((String)(prefix + strategy.getFilterString() + postfix));
        query.param("id", (Object)id);
        query.param("semesters", semesters);
        List clazzIds = this.entityDao.search((QueryBuilder)query);
        List rs = CollectUtils.newArrayList();
        if (CollectUtils.isNotEmpty((Collection)clazzIds)) {
            rs = this.entityDao.get(Clazz.class, (Serializable[])clazzIds.toArray(new Long[0]));
        }
        return rs;
    }

    @Override
    public List<Clazz> getClazzByCategory(Serializable id, ClazzFilterStrategy strategy, Semester semester) {
        if (null == id || null == semester.getId()) {
            return CollectUtils.newArrayList((int)0);
        }
        return this.getClazzByCategory(id, strategy, Collections.singletonList(semester));
    }

    @Override
    public List<Clazz> copy(List<Clazz> clazzes, TaskCopyParams params) {
        ArrayList<Clazz> copiedTasks = new ArrayList<Clazz>();
        for (Clazz clazz : clazzes) {
            Clazz copy = clazz.clone();
            if (!params.isCopyCourseTakers()) {
                copy.getEnrollment().getCourseTakers().clear();
                copy.getEnrollment().setStdCount(0);
            } else {
                for (CourseTaker taker : copy.getEnrollment().getCourseTakers()) {
                    taker.setSemester(params.getSemester());
                    taker.setElectionMode((ElectionMode)Model.newInstance(ElectionMode.class, (Serializable)Integer.valueOf(1)));
                }
            }
            copy.setStatus(AuditStatus.UNSUBMITTED);
            copy.setSemester(params.getSemester());
            ClazzElectionUtil.normalizeTeachClass(copy);
            copiedTasks.add(copy);
        }
        for (Clazz copy : copiedTasks) {
            this.clazzDao.saveOrUpdate(copy);
            this.clazzLogHelper.log(ClazzLogBuilder.create(copy, "\u590d\u5236\u4efb\u52a1,\u751f\u6210\u4efb\u52a1"));
        }
        return copiedTasks;
    }

    @Override
    public <T extends Entity<?>> List<Clazz> getClazzes(Semester semester, T entity) {
        OqlBuilder builder = OqlBuilder.from(Clazz.class, (String)"clazz");
        builder.where("clazz.semester =:semester", (Object)semester);
        Condition con = CourseLimitUtils.build(entity, "lgi");
        List params = con.getParams();
        builder.where("exists(from clazz.enrollment.restrictions lg join lg.items as lgi where" + con.getContent() + ")", params.get(0), params.get(1), params.get(2), new Object[0]);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public void fillTeachers(Long[] teacherIds, Clazz clazz) {
        if (teacherIds == null || teacherIds.length == 0) {
            clazz.getTeachers().clear();
        } else {
            ArrayList<Teacher> teachers = new ArrayList<Teacher>();
            for (Long teacherId : teacherIds) {
                if (null == teacherId) continue;
                teachers.add((Teacher)this.entityDao.get(Teacher.class, (Serializable)teacherId));
            }
            if (!teachers.equals(clazz.getTeachers())) {
                clazz.getTeachers().clear();
                clazz.getTeachers().addAll(teachers);
            }
        }
    }

    @Override
    public void adjustWeekstateBySchedule(Semester semester, List<Clazz> clazzes) {
        if (null == clazzes || clazzes.isEmpty()) {
            return;
        }
        Map offsets = CollectUtils.newHashMap();
        for (WeekDay day : WeekDay.All) {
            offsets.put(day, Pair.of((Object)WeekTimeBuilder.getOffset(semester, day), (Object)WeekTimeBuilder.getReverseOffset(semester, day)));
        }
        for (Clazz l : clazzes) {
            Set<ClazzActivity> activities = l.getSchedule().getActivities();
            if (activities.isEmpty()) continue;
            WeekState state = new WeekState(0L);
            for (ClazzActivity ac : activities) {
                WeekTime time = ac.getTime();
                if (time.getStartOn().getYear() == semester.getBeginOn().getYear()) {
                    state = new WeekState(state.value | time.getWeekstate().value >> (Integer)((Pair)offsets.get((Object)time.getWeekday()))._1);
                    continue;
                }
                state = new WeekState(state.value | time.getWeekstate().value << (Integer)((Pair)offsets.get((Object)time.getWeekday()))._2);
            }
            if (l.getSchedule().getWeekstate().equals((Object)state)) continue;
            l.getSchedule().setWeekstate(state);
        }
    }

    @Override
    public void normalizeActivity(Clazz l) {
        List newCas = CollectUtils.newArrayList();
        for (ClazzActivity ca : l.getSchedule().getActivities()) {
            if (!WeekTimeBuilder.needNormalize(ca.getTime())) continue;
            WeekTime next = WeekTimeBuilder.normalize(ca.getTime());
            ClazzActivity newCa = new ClazzActivity();
            newCa.setClazz(l);
            newCa.setTime(next);
            newCa.getTeachers().addAll(ca.getTeachers());
            newCa.getRooms().addAll(ca.getRooms());
            newCas.add(newCa);
        }
        if (!newCas.isEmpty()) {
            l.getSchedule().getActivities().addAll(newCas);
        }
        ArrayList<ClazzActivity> activityList = new ArrayList<ClazzActivity>();
        activityList.addAll(l.getSchedule().getActivities());
        List<ClazzActivity> mergedActivityList = ClazzActivity.mergeActivites(activityList);
        l.getSchedule().getActivities().retainAll(mergedActivityList);
        OqlBuilder oq = OqlBuilder.from(Occupancy.class, (String)"occupancy");
        oq.where("occupancy.activityId = :activityId and occupancy.app.id=:appId", (Object)l.getId(), (Object)RoomOccupyApp.COURSE);
        oq.where("occupancy.activityType = :activityType", (Object)new ActivityType(1));
        List occupancies = this.entityDao.search((QueryBuilder)oq);
        Map occupancyMaps = CollectUtils.newHashMap();
        for (Object o : occupancies) {
            List occsOneDay = (List)occupancyMaps.get(o.getTime().getStartOn());
            if (null == occsOneDay) {
                occsOneDay = CollectUtils.newArrayList();
                occupancyMaps.put(o.getTime().getStartOn(), occsOneDay);
            }
            occsOneDay.add(o);
        }
        Map caMaps = CollectUtils.newHashMap();
        for (ClazzActivity ca : l.getSchedule().getActivities()) {
            List casOneDay = (List)caMaps.get(ca.getTime().getStartOn());
            if (null == casOneDay) {
                casOneDay = CollectUtils.newArrayList();
                caMaps.put(ca.getTime().getStartOn(), casOneDay);
            }
            casOneDay.add(ca);
        }
        ArrayList<Occupancy> savedOccupancies = new ArrayList<Occupancy>();
        for (Map.Entry entry : caMaps.entrySet()) {
            Date startOn = (Date)entry.getKey();
            List cas = (List)entry.getValue();
            ArrayList ocs = (ArrayList)occupancyMaps.get(startOn);
            if (null == ocs) {
                ocs = new ArrayList();
            }
            for (ClazzActivity ca : cas) {
                for (Classroom r : ca.getRooms()) {
                    Occupancy occupancy = null;
                    if (cas.size() == 1 && ocs.size() == 1) {
                        occupancy = (Occupancy)((Object)ocs.get(0));
                        if (!ca.getTime().equals((Object)occupancy.getTime())) {
                            occupancy.setTime(ca.getTime());
                        }
                        if (!occupancy.getRoom().equals((Object)r)) {
                            occupancy.setRoom(r);
                        }
                        savedOccupancies.add(occupancy);
                        occupancies.remove((Object)occupancy);
                        continue;
                    }
                    for (Occupancy occ : ocs) {
                        if (!r.equals((Object)occ.getRoom())) continue;
                        occupancy = occ;
                        break;
                    }
                    if (occupancy != null) {
                        if (!ca.getTime().equals((Object)occupancy.getTime())) {
                            occupancy.setTime(ca.getTime());
                        }
                        if (!occupancy.getRoom().equals((Object)r)) {
                            occupancy.setRoom(r);
                        }
                        savedOccupancies.add(occupancy);
                        occupancies.remove((Object)occupancy);
                        continue;
                    }
                    Occupancy newOcc = new Occupancy();
                    newOcc.setTime(((ClazzActivity)cas.get(0)).getTime());
                    newOcc.setApp(new RoomOccupyApp(RoomOccupyApp.COURSE));
                    newOcc.setActivityId((Long)l.getId());
                    newOcc.setActivityType(new ActivityType(1));
                    newOcc.setRoom(r);
                    newOcc.setComments(l.getCrn() + "[" + l.getCourse().getName() + "]");
                    savedOccupancies.add(newOcc);
                }
            }
        }
        this.entityDao.saveOrUpdate(new Object[]{l, savedOccupancies});
        if (!occupancies.isEmpty()) {
            this.entityDao.remove((Collection)occupancies);
        }
    }

    public void setClazzDao(ClazzDao clazzDao) {
        this.clazzDao = clazzDao;
    }

    public void setClazzLogHelper(ClazzLogHelper clazzLogHelper) {
        this.clazzLogHelper = clazzLogHelper;
    }
}

