/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.config;

import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.code.edu.model.GradeType;

@Entity(name="org.openurp.edu.grade.config.GradeInputSwitch")
public class GradeInputSwitch
extends LongIdObject {
    private static final long serialVersionUID = 6765368922449105678L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    private Date beginAt;
    private Date endAt;
    @ManyToMany
    private Set<GradeType> types = CollectUtils.newHashSet();
    private boolean needValidate = false;
    private String remark;

    public boolean checkOpen(Date date) {
        if (null == this.getBeginAt() || null == this.getEndAt()) {
            return false;
        }
        return !date.after(this.getEndAt()) && !this.getBeginAt().after(date);
    }

    public boolean checkOpen() {
        return this.checkOpen(new Date());
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Date getEndAt() {
        return this.endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public Date getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(Date beginAt) {
        this.beginAt = beginAt;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Set<GradeType> getTypes() {
        return this.types;
    }

    public void setTypes(Set<GradeType> types) {
        this.types = types;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isNeedValidate() {
        return this.needValidate;
    }

    public void setNeedValidate(boolean needValidate) {
        this.needValidate = needValidate;
    }
}

