/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.StdGpa;
import org.openurp.edu.grade.course.model.StdSemesterGpa;
import org.openurp.edu.grade.course.model.StdYearGpa;
import org.openurp.edu.grade.course.service.CourseGradeProvider;
import org.openurp.edu.grade.course.service.GpaStatService;
import org.openurp.edu.grade.course.service.impl.BestGradeFilter;
import org.openurp.edu.grade.course.service.impl.GpaPolicy;
import org.openurp.edu.grade.course.service.impl.MultiStdGpa;

public class BestGpaStatService
implements GpaStatService {
    private CourseGradeProvider courseGradeProvider;
    private GpaPolicy gpaPolicy;
    private BestGradeFilter bestGradeFilter;

    @Override
    public StdGpa stat(Student std, List<CourseGrade> grades) {
        StdGpa stdGpa = this.gpaPolicy.calc(std, grades, true);
        StdGpa stdGpa2 = this.gpaPolicy.calc(std, this.bestGradeFilter.filter(grades), false);
        stdGpa.setGradeCount(stdGpa2.getGradeCount());
        stdGpa.setCredits(stdGpa2.getCredits());
        stdGpa.setTotalCredits(stdGpa2.getTotalCredits());
        stdGpa.setGa(stdGpa2.getGa());
        stdGpa.setGpa(stdGpa2.getGpa());
        return stdGpa;
    }

    @Override
    public void refresh(StdGpa stdGpa) {
        StdGpa newer = this.stat(stdGpa.getStd(), new Semester[0]);
        this.merge(stdGpa, newer);
    }

    @Override
    public void refresh(StdGpa stdGpa, List<CourseGrade> grades) {
        StdGpa newer = this.stat(stdGpa.getStd(), grades);
        this.merge(stdGpa, newer);
    }

    @Override
    public StdGpa stat(Student std, Semester ... semesters) {
        return this.stat(std, this.courseGradeProvider.getPublished(std, semesters));
    }

    @Override
    public MultiStdGpa stat(Collection<Student> stds, Semester ... semesters) {
        MultiStdGpa multiStdGpa = new MultiStdGpa();
        for (Student std : stds) {
            StdGpa stdGpa = this.stat(std, semesters);
            if (stdGpa == null) continue;
            multiStdGpa.getStdGpas().add(stdGpa);
        }
        multiStdGpa.statSemestersFromStdGpa();
        return multiStdGpa;
    }

    private void merge(StdGpa target, StdGpa source) {
        StdYearGpa targetTerm;
        StdSemesterGpa targetTerm2;
        target.setGa(source.getGa());
        target.setGpa(source.getGpa());
        target.setGradeCount(source.getGradeCount());
        target.setCredits(source.getCredits());
        target.setTotalCredits(source.getTotalCredits());
        Map<Semester, StdSemesterGpa> existedTerms = this.semesterGpa2Map(target.getSemesterGpas());
        Map<Semester, StdSemesterGpa> sourceTerms = this.semesterGpa2Map(source.getSemesterGpas());
        for (Map.Entry<Semester, StdSemesterGpa> entry : sourceTerms.entrySet()) {
            targetTerm2 = existedTerms.get(entry.getKey());
            StdSemesterGpa sourceTerm = entry.getValue();
            if (null == targetTerm2) {
                source.getSemesterGpas().remove((Object)sourceTerm);
                target.add(sourceTerm);
                continue;
            }
            targetTerm2.setGa(sourceTerm.getGa());
            targetTerm2.setGpa(sourceTerm.getGpa());
            targetTerm2.setGradeCount(sourceTerm.getGradeCount());
            targetTerm2.setCredits(sourceTerm.getCredits());
            targetTerm2.setTotalCredits(sourceTerm.getTotalCredits());
        }
        for (Map.Entry<Semester, StdSemesterGpa> entry : existedTerms.entrySet()) {
            if (null != sourceTerms.get(entry.getKey())) continue;
            targetTerm2 = entry.getValue();
            targetTerm2.setStdGpa(null);
            target.getSemesterGpas().remove((Object)targetTerm2);
        }
        Map<String, StdYearGpa> existedYears = this.yearGpa2Map(target.getYearGpas());
        Map<String, StdYearGpa> sourceYears = this.yearGpa2Map(source.getYearGpas());
        for (Map.Entry<String, StdYearGpa> entry : sourceYears.entrySet()) {
            targetTerm = existedYears.get(entry.getKey());
            StdYearGpa sourceTerm = entry.getValue();
            if (null == targetTerm) {
                source.getYearGpas().remove((Object)sourceTerm);
                target.add(sourceTerm);
                continue;
            }
            targetTerm.setGa(sourceTerm.getGa());
            targetTerm.setGpa(sourceTerm.getGpa());
            targetTerm.setGradeCount(sourceTerm.getGradeCount());
            targetTerm.setCredits(sourceTerm.getCredits());
            targetTerm.setTotalCredits(sourceTerm.getTotalCredits());
        }
        for (Map.Entry<String, StdYearGpa> entry : existedYears.entrySet()) {
            if (null != sourceYears.get(entry.getKey())) continue;
            targetTerm = entry.getValue();
            targetTerm.setStdGpa(null);
            target.getYearGpas().remove((Object)targetTerm);
        }
        target.setUpdatedAt(source.getUpdatedAt());
    }

    private Map<Semester, StdSemesterGpa> semesterGpa2Map(List<StdSemesterGpa> gpas) {
        Map datas = CollectUtils.newHashMap();
        for (StdSemesterGpa a : gpas) {
            datas.put(a.getSemester(), a);
        }
        return datas;
    }

    private Map<String, StdYearGpa> yearGpa2Map(List<StdYearGpa> gpas) {
        Map datas = CollectUtils.newHashMap();
        for (StdYearGpa a : gpas) {
            datas.put(a.getSchoolYear(), a);
        }
        return datas;
    }

    public void setCourseGradeProvider(CourseGradeProvider provider) {
        this.courseGradeProvider = provider;
    }

    public void setGpaPolicy(GpaPolicy gpaPolicy) {
        this.gpaPolicy = gpaPolicy;
    }

    public void setBestGradeFilter(BestGradeFilter bestGradeFilter) {
        this.bestGradeFilter = bestGradeFilter;
    }
}

