/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.stat;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.StdGpa;
import org.openurp.edu.grade.course.service.impl.GradeFilter;

public class StdGrade {
    protected Student std;
    protected List<CourseGrade> grades;
    protected List<GradeFilter> gradeFilters;
    protected StdGpa stdGpa;
    protected Comparator<CourseGrade> cmp;

    public StdGrade() {
    }

    public Map<String, CourseGrade> toGradeMap() {
        Map gradeMap = CollectUtils.newHashMap();
        if (null == this.grades || this.grades.isEmpty()) {
            return gradeMap;
        }
        for (CourseGrade courseGrade : this.grades) {
            gradeMap.put(((Long)courseGrade.getCourse().getId()).toString(), courseGrade);
        }
        return gradeMap;
    }

    public StdGrade(Student std, List<CourseGrade> courseGrades, Comparator cmp, List<GradeFilter> gradeFilters) {
        this.std = std;
        this.gradeFilters = gradeFilters;
        this.grades = courseGrades;
        if (null != gradeFilters) {
            for (GradeFilter filter : gradeFilters) {
                this.grades = filter.filter(this.grades);
            }
        }
        if (null != cmp) {
            Collections.sort(this.grades, cmp);
        }
        this.cmp = cmp;
    }

    public void filterGrade(GradeFilter gradeFilter) {
        if (null != gradeFilter) {
            this.grades = gradeFilter.filter(this.grades);
        }
    }

    public Float getCredits() {
        if (null == this.grades || this.grades.isEmpty()) {
            return new Float(0.0f);
        }
        float credits = 0.0f;
        for (CourseGrade courseGrade : this.grades) {
            if (!courseGrade.isPassed()) continue;
            credits += courseGrade.getCourse().getDefaultCredits();
        }
        return new Float(credits);
    }

    public void addGrade(CourseGrade grade) {
        this.grades.add(grade);
    }

    public List<CourseGrade> getGrades() {
        return this.grades;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public StdGpa getStdGpa() {
        return this.stdGpa;
    }

    public void setStdGpa(StdGpa stdGpa) {
        this.stdGpa = stdGpa;
    }

    public void setGrades(List<CourseGrade> grades) {
        this.grades = grades;
    }

    public List<GradeFilter> getGradeFilters() {
        return this.gradeFilters;
    }

    public void setGradeFilters(List<GradeFilter> gradeFilters) {
        this.gradeFilters = gradeFilters;
    }

    public Comparator<CourseGrade> getCmp() {
        return this.cmp;
    }

    public void setCmp(Comparator<CourseGrade> cmp) {
        this.cmp = cmp;
    }
}

