/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.plan.adapters.GroupResultAdapter;
import org.openurp.edu.grade.plan.model.AuditCourseResult;
import org.openurp.edu.grade.plan.model.AuditPlanResult;
import org.openurp.edu.grade.plan.model.AuditStat;
import org.openurp.edu.program.model.CourseGroup;

@Entity(name="org.openurp.edu.grade.plan.model.AuditGroupResult")
public class AuditGroupResult
extends LongIdObject {
    private static final long serialVersionUID = -6622283837918622674L;
    @Size(max=200)
    @NotNull
    private String name;
    @Size(max=100)
    private String indexno;
    private AuditStat auditStat = new AuditStat();
    @OneToMany(mappedBy="groupResult", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<AuditCourseResult> courseResults = CollectUtils.newArrayList();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType courseType;
    @ManyToOne(fetch=FetchType.LAZY)
    private AuditGroupResult parent;
    private boolean passed;
    @OneToMany(mappedBy="parent", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<AuditGroupResult> children = CollectUtils.newArrayList();
    private short subCount;
    private String remark;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private AuditPlanResult planResult;

    public void attachTo(AuditPlanResult planResult) {
        this.setPlanResult(planResult);
        planResult.getGroupResults().add(this);
        for (AuditGroupResult groupResult : this.children) {
            groupResult.attachTo(planResult);
        }
    }

    public void detach() {
        if (null != this.getPlanResult()) {
            this.getPlanResult().getGroupResults().remove((Object)this);
        }
        this.setPlanResult(null);
        for (AuditGroupResult groupResult : this.children) {
            groupResult.detach();
        }
    }

    public String getName() {
        return null != this.name ? this.name : this.courseType.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuditGroupResult() {
    }

    public AuditGroupResult(CourseGroup group) {
        this.name = group.getName();
        this.courseType = group.getCourseType();
        this.indexno = group.getIndexno();
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public AuditStat getAuditStat() {
        return this.auditStat;
    }

    public void setAuditStat(AuditStat auditStat) {
        this.auditStat = auditStat;
    }

    public List<AuditCourseResult> getCourseResults() {
        return this.courseResults;
    }

    public AuditCourseResult getCourseResult(Course course) {
        HashMap results = new HashMap();
        for (AuditCourseResult car : this.getCourseResults()) {
            if (!course.equals(car.getCourse())) continue;
            return car;
        }
        return null;
    }

    public Map<Course, AuditCourseResult> getCourseResultMap() {
        HashMap<Course, AuditCourseResult> results = new HashMap<Course, AuditCourseResult>();
        for (AuditCourseResult car : this.getCourseResults()) {
            results.put(car.getCourse(), car);
        }
        return results;
    }

    public void setCourseResults(List<AuditCourseResult> planCourseAuditResults) {
        this.courseResults = planCourseAuditResults;
    }

    public List<AuditGroupResult> getChildren() {
        return this.children;
    }

    public void setChildren(List<AuditGroupResult> children) {
        this.children = children;
    }

    public AuditGroupResult getSuperResult() {
        return null != this.planResult ? new GroupResultAdapter(this.planResult) : null;
    }

    public AuditGroupResult getParent() {
        return this.parent;
    }

    public void setParent(AuditGroupResult parent) {
        this.parent = parent;
    }

    public void addCourseResult(AuditCourseResult courseResult) {
        courseResult.setGroupResult(this);
        this.getCourseResults().add(courseResult);
        if (courseResult.isPassed()) {
            this.addPassedCourse(this, courseResult.getCourse());
        }
    }

    public void updateCourseResult(AuditCourseResult rs) {
        if (rs.isPassed()) {
            this.addPassedCourse(rs.getGroupResult(), rs.getCourse());
        }
    }

    private void addPassedCourse(AuditGroupResult groupResult, Course course) {
        if (null == groupResult) {
            return;
        }
        Student std = groupResult.planResult.getStd();
        AuditStat auditStat = groupResult.getAuditStat();
        if (!auditStat.getPassedCourses().contains(course)) {
            auditStat.getPassedCourses().add(course);
            auditStat.addCredits(course.getCredits(std.getLevel()));
            auditStat.addNum(1);
        }
        if (null != groupResult.getParent()) {
            this.addPassedCourse(groupResult.getParent(), course);
        } else {
            AuditStat planAuditStat = groupResult.getPlanResult().getAuditStat();
            if (!planAuditStat.getPassedCourses().contains(course)) {
                planAuditStat.getPassedCourses().add(course);
                planAuditStat.addCredits(course.getCredits(std.getLevel()));
                planAuditStat.addNum(1);
            }
        }
    }

    public void addChild(AuditGroupResult gr) {
        gr.setParent(this);
        this.children.add(gr);
    }

    public void removeChild(AuditGroupResult gr) {
        gr.setParent(null);
        this.children.remove((Object)gr);
    }

    public static void checkPassed(AuditGroupResult groupResult, boolean isRecursive) {
        if (null == groupResult) {
            return;
        }
        boolean childrenPassed = true;
        int requiredSubCount = groupResult.getSubCount();
        if (requiredSubCount < 0) {
            requiredSubCount = groupResult.getChildren().size();
        }
        if (requiredSubCount > 0) {
            int groupPassedNum = 0;
            for (AuditGroupResult childResult : groupResult.getChildren()) {
                if (!childResult.isPassed()) continue;
                ++groupPassedNum;
            }
            childrenPassed = groupPassedNum >= requiredSubCount;
        }
        groupResult.setPassed(childrenPassed && groupResult.getAuditStat().isPassed());
        if (isRecursive) {
            if (null != groupResult.getParent()) {
                AuditGroupResult.checkPassed(groupResult.getParent(), true);
            } else {
                AuditGroupResult.checkPassed(new GroupResultAdapter(groupResult.getPlanResult()), false);
            }
        }
    }

    public void checkPassed(boolean isRecursive) {
        AuditGroupResult.checkPassed(this, isRecursive);
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public AuditPlanResult getPlanResult() {
        return this.planResult;
    }

    public void setPlanResult(AuditPlanResult planResult) {
        this.planResult = planResult;
    }

    public short getSubCount() {
        return this.subCount;
    }

    public void setSubCount(short subCount) {
        this.subCount = subCount;
    }

    public String getIndexno() {
        return this.indexno;
    }

    public void setIndexno(String indexno) {
        this.indexno = indexno;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

