/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.dao.hibernate;

import java.sql.Date;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.User;
import org.openurp.base.time.Terms;
import org.openurp.edu.program.app.dao.ExecutionPlanCourseModifyAuditDao;
import org.openurp.edu.program.app.model.ExecutionPlanCourseModify;
import org.openurp.edu.program.app.model.ExecutionPlanCourseModifyDetailAfter;
import org.openurp.edu.program.app.model.ExecutionPlanCourseModifyDetailBefore;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.ExecutionPlanCourse;
import org.openurp.edu.program.plan.dao.PlanCourseCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.ExecutionPlanAuditException;

public class ExecutionPlanCourseModifyAuditDaoHibernate
extends HibernateEntityDao
implements ExecutionPlanCourseModifyAuditDao {
    private PlanCourseCommonDao planCourseCommonDao;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void approved(ExecutionPlanCourseModify apply, User assessor) throws ExecutionPlanAuditException {
        if (!ExecutionPlanCourseModify.INITREQUEST.equals(apply.getFlag())) {
            throw new ExecutionPlanAuditException("\u53ea\u80fd\u5bf9\u5f85\u5ba1\u6838\u7684\u7533\u8bf7\u8fdb\u884c\u5ba1\u6838");
        }
        ExecutionPlan plan = (ExecutionPlan)this.get(ExecutionPlan.class, apply.getExecutionPlan().getId());
        if (plan == null) {
            throw new ExecutionPlanAuditException("\u60a8\u8981\u4fee\u6539\u7684\u4e13\u4e1a\u57f9\u517b\u8ba1\u5212\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002");
        }
        if (ExecutionPlanCourseModify.ADD.equals(apply.getRequisitionType())) {
            ExecutionPlanCourseModifyDetailAfter after = apply.getNewPlanCourse();
            ExecutionPlanCourse planCourse = new ExecutionPlanCourse();
            planCourse.setCourse(after.getCourse());
            planCourse.setTerms(after.getTerms());
            if (planCourse.getTerms() == null) {
                planCourse.setTerms(new Terms(0));
            }
            planCourse.setRemark(after.getRemark());
            planCourse.setCompulsory(after.isCompulsory());
            ExecutionCourseGroup mg = (ExecutionCourseGroup)this.get(ExecutionCourseGroup.class, after.getFakeCourseGroup().getId());
            if (mg == null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728\uff1a" + after.getFakeCourseGroup().getCourseType().getName());
            }
            planCourse.setGroup(mg);
            planCourse.setDepartment(after.getDepartment());
            this.planCourseCommonDao.addPlanCourse(planCourse, plan);
        } else if (ExecutionPlanCourseModify.DELETE.equals(apply.getRequisitionType())) {
            ExecutionPlanCourseModifyDetailBefore before = apply.getOldPlanCourse();
            Course course = before.getCourse();
            ExecutionPlanCourse planCourse = this.planCourseCommonDao.getExecutionPlanCourseByCourse(plan, course);
            if (planCourse == null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u4e0d\u5b58\u5728\uff1a" + course);
            }
            this.planCourseCommonDao.removePlanCourse(planCourse, plan);
        } else if (ExecutionPlanCourseModify.MODIFY.equals(apply.getRequisitionType())) {
            ExecutionPlanCourseModifyDetailBefore before = apply.getOldPlanCourse();
            ExecutionPlanCourse planCourse = this.planCourseCommonDao.getExecutionPlanCourseByCourse(plan, before.getCourse());
            if (planCourse == null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u4e0d\u5b58\u5728\uff1a" + before.getCourse());
            }
            ExecutionCourseGroup oldGroup = (ExecutionCourseGroup)planCourse.getGroup();
            ExecutionPlanCourseModifyDetailAfter after = apply.getNewPlanCourse();
            planCourse.setCompulsory(after.isCompulsory());
            planCourse.setCourse(after.getCourse());
            planCourse.setTerms(after.getTerms());
            if (planCourse.getTerms() == null) {
                planCourse.setTerms(new Terms(0));
            }
            planCourse.setRemark(after.getRemark());
            ExecutionCourseGroup mg = (ExecutionCourseGroup)this.get(ExecutionCourseGroup.class, after.getFakeCourseGroup().getId());
            if (mg == null) {
                throw new ExecutionPlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728\uff1a" + after.getFakeCourseGroup().getCourseType().getName());
            }
            planCourse.setGroup(mg);
            planCourse.setDepartment(after.getDepartment());
            this.planCourseCommonDao.updatePlanCourse(planCourse, plan);
            this.planCourseGroupCommonDao.saveOrUpdateCourseGroup(oldGroup);
        } else {
            throw new ExecutionPlanAuditException("\u9519\u8bef\u7684\u8ba1\u5212\u8bfe\u7a0b\u53d8\u66f4\u7533\u8bf7\u7c7b\u578b");
        }
        apply.setFlag(ExecutionPlanCourseModify.ACCEPT);
        apply.setAssessor(assessor);
        apply.setReplyDate(new Date(System.currentTimeMillis()));
        this.saveOrUpdate(new Object[]{apply});
    }

    @Override
    public void rejected(ExecutionPlanCourseModify apply, User assessor) throws ExecutionPlanAuditException {
        if (!ExecutionPlanCourseModify.INITREQUEST.equals(apply.getFlag())) {
            throw new ExecutionPlanAuditException("\u53ea\u80fd\u5bf9\u5f85\u5ba1\u6838\u7684\u7533\u8bf7\u8fdb\u884c\u5ba1\u6838");
        }
        apply.setFlag(ExecutionPlanCourseModify.REFUSE);
        apply.setAssessor(assessor);
        apply.setReplyDate(new Date(System.currentTimeMillis()));
        this.saveOrUpdate(new Object[]{apply});
    }

    public void setPlanCourseCommonDao(PlanCourseCommonDao planCourseCommonDao) {
        this.planCourseCommonDao = planCourseCommonDao;
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

