/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.service.impl;

import java.io.Serializable;
import java.util.List;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.edu.program.app.dao.ExecutionPlanCourseGroupModifyApplyDao;
import org.openurp.edu.program.app.model.ExecutionCourseGroupModify;
import org.openurp.edu.program.app.model.ExecutionCourseGroupModifyDetailAfter;
import org.openurp.edu.program.app.model.ExecutionCourseGroupModifyDetailBefore;
import org.openurp.edu.program.app.model.ExecutionPlanCourseModify;
import org.openurp.edu.program.app.model.FakeCourseGroup;
import org.openurp.edu.program.app.service.ExecutionPlanCourseGroupModifyApplyService;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;

public class ExecutionPlanCourseGroupModifyApplyServiceImpl
extends BaseServiceImpl
implements ExecutionPlanCourseGroupModifyApplyService {
    private ExecutionPlanCourseGroupModifyApplyDao executePlanCourseGroupModifyApplyDao;

    @Override
    public List<ExecutionCourseGroupModify> appliesOfPlan(Long planId) {
        OqlBuilder oql = OqlBuilder.from(ExecutionCourseGroupModify.class, (String)"applyBean");
        oql.where("applyBean.executePlan.id =:planId", (Object)planId);
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public List<ExecutionCourseGroupModify> myApplies(Long planId, Long userId) {
        OqlBuilder oql = OqlBuilder.from(ExecutionCourseGroupModify.class, (String)"apply");
        oql.where("apply.executePlan.id =:planId", (Object)planId).where("apply.proposer.id =:userId", (Object)userId).orderBy("apply.flag").orderBy(Order.desc((String)"apply.applyDate"));
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public List<ExecutionCourseGroup> myReadyModifyApply(Long planId, Long userId) {
        OqlBuilder query = OqlBuilder.from((String)(ExecutionCourseGroupModify.class.getName() + " apply, " + ExecutionPlan.class.getName() + " plan"));
        query.select("select cgroup").where("apply.executePlan.id = plan.id").join("plan.groups", "cgroup").where("apply.executePlan.id = :planId", (Object)planId).where("apply.proposer.id = :userId", (Object)userId).where("apply.flag = :flag", (Object)ExecutionPlanCourseModify.INITREQUEST).where("exists(select state.id from " + ExecutionCourseGroupModifyDetailBefore.class.getName() + " state where state.apply.id = apply.id and state.courseType=cgroup.courseType)");
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<ExecutionCourseGroupModify> myReadyAddApplies(Long planId, Long userId) {
        OqlBuilder oql = OqlBuilder.from(ExecutionCourseGroupModify.class, (String)"apply");
        oql.where("apply.executePlan.id =:planId", (Object)planId).where("apply.proposer.id =:userId", (Object)userId).where("apply.flag = :flag", (Object)ExecutionPlanCourseModify.INITREQUEST).where("apply.requisitionType = :requisitionType", (Object)ExecutionPlanCourseModify.ADD).orderBy(Order.desc((String)"apply.applyDate"));
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public void saveModifyApply(ExecutionCourseGroupModify modifyBean, Long courseGroupId, ExecutionCourseGroupModifyDetailAfter after) {
        ExecutionCourseGroupModifyDetailBefore before = null;
        if (courseGroupId != null) {
            ExecutionCourseGroup courseGroup = (ExecutionCourseGroup)this.entityDao.get(ExecutionCourseGroup.class, (Serializable)courseGroupId);
            before = new ExecutionCourseGroupModifyDetailBefore();
            before.setApply(modifyBean);
            before.setSubCount(courseGroup.getSubCount());
            before.setCourseType(courseGroup.getCourseType());
            before.setCourseCount(courseGroup.getCourseCount());
            before.setCredits(courseGroup.getCredits());
            before.setParent(new FakeCourseGroup((ExecutionCourseGroup)courseGroup.getParent()));
            before.setRemark(courseGroup.getRemark());
            before.setTermCredits(courseGroup.getTermCredits());
        }
        this.executePlanCourseGroupModifyApplyDao.saveModifyApply(modifyBean, before, after);
    }

    public void setExecutionPlanCourseGroupModifyApplyDao(ExecutionPlanCourseGroupModifyApplyDao executePlanCourseGroupModifyApplyDao) {
        this.executePlanCourseGroupModifyApplyDao = executePlanCourseGroupModifyApplyDao;
    }
}

