/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.hibernate.annotations.Type;
import org.openurp.base.time.Terms;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.PlanCourseComparator;
import org.openurp.edu.program.utils.PlanUtils;

@MappedSuperclass
public abstract class AbstractCourseGroup
extends LongIdObject
implements CourseGroup,
Cloneable {
    private static final long serialVersionUID = 1347767253840431206L;
    @Size(max=100)
    private String givenName;
    protected short subCount;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected CourseType courseType;
    private float credits;
    private int creditHours;
    private String hourRatios;
    private short courseCount;
    @Size(max=2000)
    private String remark;
    private String termCredits;
    @Size(max=30)
    @NotNull
    private String indexno;
    private boolean autoAddup;
    @NotNull
    @Type(type="org.openurp.base.time.hibernate.TermsType")
    protected Terms terms = Terms.Empty;

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (null != this.courseType) {
            sb.append(this.courseType.getName());
        }
        if (null != this.givenName) {
            sb.append(" ").append(this.givenName);
        }
        return sb.toString();
    }

    @Override
    public int getIndex() {
        int idx;
        String index = Strings.substringAfterLast((String)this.indexno, (String)".");
        if (Strings.isEmpty((CharSequence)index)) {
            index = this.indexno;
        }
        if ((idx = Numbers.toInt((String)index)) <= 0) {
            idx = 1;
        }
        return idx;
    }

    @Override
    public short getSubCount() {
        return this.subCount;
    }

    @Override
    public void setSubCount(short subCount) {
        this.subCount = subCount;
    }

    @Override
    public void addChildGroup(CourseGroup group) {
        group.setParent(this);
        this.getChildren().add(group);
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    public void addPlanCourse(PlanCourse planCourse) {
        for (PlanCourse planCourse1 : this.getPlanCourses()) {
            if (!planCourse.getCourse().equals(planCourse1.getCourse())) continue;
            return;
        }
        planCourse.setGroup(this);
        this.getPlanCourses().add(planCourse);
    }

    @Override
    public void removePlanCourse(PlanCourse course) {
        this.getPlanCourses().remove(course);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractCourseGroup courseGroup = (AbstractCourseGroup)super.clone();
        courseGroup.setId(null);
        List groups = courseGroup.getChildren();
        List groupClones = CollectUtils.newArrayList();
        for (CourseGroup cg : groups) {
            CourseGroup groupClone = (CourseGroup)cg.clone();
            groupClones.add(groupClone);
            groupClone.setParent(courseGroup);
        }
        courseGroup.setChildren(groupClones);
        courseGroup.setPlanCourses(new ArrayList());
        for (PlanCourse planCourse : this.getPlanCourses()) {
            courseGroup.addPlanCourse((PlanCourse)planCourse.clone());
        }
        return courseGroup;
    }

    @Override
    public CourseType getCourseType() {
        return this.courseType;
    }

    @Override
    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public float getCredits() {
        return this.credits;
    }

    @Override
    public void setCredits(float credits) {
        this.credits = credits;
    }

    @Override
    public short getCourseCount() {
        return this.courseCount;
    }

    @Override
    public void setCourseCount(short courseCount) {
        this.courseCount = courseCount;
    }

    @Override
    public String getTermCredits() {
        return this.termCredits;
    }

    @Override
    public void setTermCredits(String termCredits) {
        this.termCredits = termCredits;
    }

    @Override
    public String getIndexno() {
        return this.indexno;
    }

    @Override
    public void setIndexno(String indexno) {
        this.indexno = indexno;
    }

    @Override
    public boolean isAutoAddup() {
        return this.autoAddup;
    }

    public void setAutoAddup(boolean autoAddup) {
        this.autoAddup = autoAddup;
    }

    @Override
    public Terms getTerms() {
        return this.terms;
    }

    @Override
    public void setTerms(Terms terms) {
        this.terms = terms;
    }

    @Override
    public void addPlanCourses(List<PlanCourse> planCourses) {
        for (PlanCourse element : planCourses) {
            boolean finded = false;
            for (PlanCourse element2 : planCourses) {
                if (!((Long)element.getCourse().getId()).equals(element2.getCourse().getId())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            element.setGroup(this);
            planCourses.add(element);
        }
    }

    @Override
    public void updateCoursePlan(CoursePlan plan) {
        this.setPlan(plan);
        if (this.getChildren() != null) {
            for (CourseGroup group : this.getChildren()) {
                group.updateCoursePlan(plan);
            }
        }
    }

    public List<PlanCourse> getPlanCourses(String terms) {
        if (Strings.isEmpty((CharSequence)terms)) {
            return new ArrayList<PlanCourse>(this.getPlanCourses());
        }
        Set result = CollectUtils.newHashSet();
        Integer[] termSeq = Strings.splitToInt((String)terms);
        for (int i = 0; i < termSeq.length; ++i) {
            result.addAll(PlanUtils.getPlanCourses(this, (int)termSeq[i]));
        }
        return new ArrayList<PlanCourse>(result);
    }

    public List<PlanCourse> getOrderedPlanCourses() {
        Collections.sort(this.getPlanCourses(), new PlanCourseComparator());
        return this.getPlanCourses();
    }

    @Override
    public int compareTo(CourseGroup o) {
        return this.getIndexno().compareTo(o.getIndexno());
    }

    @Override
    public int getCreditHours() {
        return this.creditHours;
    }

    @Override
    public void setCreditHours(int creditHours) {
        this.creditHours = creditHours;
    }

    @Override
    public String getHourRatios() {
        return this.hourRatios;
    }

    @Override
    public void setHourRatios(String hourRatios) {
        this.hourRatios = hourRatios;
    }
}

