/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.dao.hibernate;

import java.util.List;
import org.apache.commons.lang3.Range;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Major;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.plan.dao.ExecutionPlanCourseGroupDao;
import org.openurp.edu.program.plan.dao.ExecutionPlanDao;

public class ExecutionPlanDaoHibernate
extends HibernateEntityDao
implements ExecutionPlanDao {
    protected SemesterService semesterService;
    protected ExecutionPlanCourseGroupDao executePlanCourseGroupDao;

    @Override
    public List<ExecutionPlan> getExecutionPlanList(String grade, Major major, EducationLevel level) {
        OqlBuilder query = OqlBuilder.from(ExecutionPlan.class, (String)"plan");
        query.where("plan.program.grade=:grade", (Object)grade).where("plan.program.major=:major", (Object)major).where("plan.program.level=:level", (Object)level);
        return this.search((QueryBuilder)query);
    }

    protected ExecutionPlan getExecutionPlan(Long id) {
        return (ExecutionPlan)this.get(ExecutionPlan.class, id);
    }

    @Override
    public List<ExecutionPlan> getExecutionPlans(Long[] planIds) {
        OqlBuilder query = OqlBuilder.from(ExecutionPlan.class, (String)"plan");
        query.where("plan.id in (:ids)", (Object)planIds);
        return this.search((QueryBuilder)query);
    }

    public Float getCreditByTerm(ExecutionPlan plan, int term) {
        Range termRange = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(plan.getTermsCount()));
        if (!termRange.contains((Object)term)) {
            throw new RuntimeException("term out range");
        }
        return null;
    }

    public void setExecutionPlanCourseGroupDao(ExecutionPlanCourseGroupDao executePlanCourseGroupDao) {
        this.executePlanCourseGroupDao = executePlanCourseGroupDao;
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }
}

