/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.dao.impl;

import java.util.List;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.ExecutionPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.util.ProgramHibernateClassGetter;

public class PlanCourseCommonDaoHibernate
extends HibernateEntityDao
implements PlanCourseCommonDao {
    private PlanCommonDao planCommonDao;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void addPlanCourse(PlanCourse planCourse, CoursePlan plan) {
        CourseGroup myGroup = (CourseGroup)this.get(ProgramHibernateClassGetter.hibernateClass(planCourse.getGroup()), (Long)planCourse.getGroup().getId());
        myGroup.addPlanCourse(planCourse);
        this.saveOrUpdate(new Object[]{planCourse});
        this.saveOrUpdate(new Object[]{myGroup});
        planCourse.setCourse((Course)this.get(Course.class, (Long)planCourse.getCourse().getId()));
        this.planCourseGroupCommonDao.updateGroupTreeCredits(this.planCourseGroupCommonDao.getTopGroup(myGroup));
        plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public void removePlanCourse(PlanCourse planCourse, CoursePlan plan) {
        CourseGroup myGroup = planCourse.getGroup();
        myGroup.getPlanCourses().remove(planCourse);
        this.remove(new Object[]{planCourse});
        this.planCourseGroupCommonDao.updateGroupTreeCredits(this.planCourseGroupCommonDao.getTopGroup(myGroup));
        plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public void updatePlanCourse(PlanCourse planCourse, CoursePlan plan) {
        CourseGroup group = planCourse.getGroup();
        this.saveOrUpdate(new Object[]{planCourse});
        this.saveOrUpdate(new Object[]{group});
        this.planCourseGroupCommonDao.updateGroupTreeCredits(this.planCourseGroupCommonDao.getTopGroup(group));
        plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public ExecutionPlanCourse getExecutionPlanCourseByCourse(ExecutionPlan executePlan, Course course) {
        OqlBuilder query = OqlBuilder.from(ProgramHibernateClassGetter.hibernateClass(executePlan), (String)"plan");
        query.select("planCourse").join("plan.groups", "cgroup").join("cgroup.planCourses", "planCourse").where("planCourse.course=:course", (Object)course).where("plan.id = :planId", (Object)executePlan.getId());
        List courses = this.search((QueryBuilder)query);
        if (null == courses || courses.size() == 0) {
            return null;
        }
        return (ExecutionPlanCourse)courses.get(0);
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }
}

