/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.openurp.base.std.model.Student;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.StdPlan;
import org.openurp.edu.program.plan.service.CoursePlanProvider;
import org.openurp.edu.program.plan.service.PersonalPlanService;
import org.openurp.edu.program.plan.service.ProgramGenParameter;
import org.openurp.edu.program.plan.util.ProgramNamingHelper;

public class PersonalPlanServiceImpl
extends BaseServiceImpl
implements PersonalPlanService {
    private CoursePlanProvider coursePlanProvider;

    @Override
    public ExecutionPlan getExecutionPlanForDiff(Student std) {
        return this.coursePlanProvider.getExecutionPlan(std);
    }

    @Override
    public StdPlan genPersonalPlan(Student std) {
        ProgramGenParameter genParameter = new ProgramGenParameter();
        genParameter.setStudent(std);
        ExecutionPlan executePlan = this.coursePlanProvider.getExecutionPlan(std);
        if (executePlan == null) {
            genParameter.setGrade(std.getGrade());
            genParameter.setDepartment(std.getDepartment());
            genParameter.setDirection(std.getDirection());
            genParameter.setDuration(std.getDuration().floatValue());
            genParameter.setLevel(std.getLevel());
            genParameter.setMajor(std.getMajor());
            genParameter.setStdType(std.getStdType());
            genParameter.setStudyType(std.getStudyType());
            genParameter.setBeginOn(std.getBeginOn());
            genParameter.setEndOn(std.getEndOn());
        }
        genParameter.setName(ProgramNamingHelper.name(std));
        return null;
    }

    public void setCoursePlanProvider(CoursePlanProvider coursePlanProvider) {
        this.coursePlanProvider = coursePlanProvider;
    }
}

