/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.EducationType;
import org.openurp.code.edu.model.ElectionMode;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.clazz.model.Enrollment;
import org.openurp.edu.clazz.model.RestrictionPair;
import org.openurp.edu.clazz.service.ClazzNameStrategy;
import org.openurp.edu.clazz.service.CourseLimitService;
import org.openurp.edu.clazz.service.RestrictionBuilder;
import org.openurp.edu.clazz.service.internal.DefaultRestrictionBuilder;

public class CourseLimitServiceImpl
extends BaseServiceImpl
implements CourseLimitService {
    ClazzNameStrategy teachclassNameStrategy;

    @Override
    @Deprecated
    public void mergeAll(Enrollment target, Enrollment source) {
    }

    @Override
    @Deprecated
    public void merge(Long mergeType, Enrollment target, Enrollment source) {
        if (ClazzRestrictionMeta.Squad.equals(mergeType)) {
            List<Squad> sourceCollection;
            HashSet<Squad> tmp_collection = new HashSet<Squad>();
            List<Squad> targetCollection = this.extractSquades(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractSquades(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, tmp_collection.toArray(new Squad[0]));
        } else if (ClazzRestrictionMeta.Department.equals(mergeType)) {
            List<Department> sourceCollection;
            HashSet<Department> tmp_collection = new HashSet<Department>();
            List<Department> targetCollection = this.extractAttendDeparts(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractAttendDeparts(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, tmp_collection.toArray(new Department[0]));
        } else if (ClazzRestrictionMeta.StdType.equals(mergeType)) {
            List<StdType> sourceCollection;
            HashSet<StdType> tmp_collection = new HashSet<StdType>();
            List<StdType> targetCollection = this.extractStdTypes(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractStdTypes(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, (Entity[])tmp_collection.toArray(new StdType[0]));
        } else if (ClazzRestrictionMeta.Direction.equals(mergeType)) {
            List<Direction> sourceCollection;
            HashSet<Direction> tmp_collection = new HashSet<Direction>();
            List<Direction> targetCollection = this.extractDirections(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractDirections(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, (Entity[])tmp_collection.toArray(new Direction[0]));
        } else if (ClazzRestrictionMeta.Gender.equals(mergeType)) {
            Gender targetGender = this.extractGender(target);
            Gender sourceGender = this.extractGender(source);
            Gender tmp_gender = null;
            if (targetGender != null && sourceGender != null && targetGender.equals((Object)sourceGender)) {
                tmp_gender = targetGender;
            }
            if (targetGender != null && sourceGender == null) {
                tmp_gender = targetGender;
            }
            if (targetGender == null && sourceGender != null) {
                tmp_gender = sourceGender;
            }
            if (tmp_gender != null) {
                this.limitEnrollment(true, target, (Entity[])new Gender[]{tmp_gender});
            }
        } else if (ClazzRestrictionMeta.Grade.equals(mergeType)) {
            String[] grades;
            String sourceGrade;
            Object tmp_grade = "";
            String targetGrade = this.extractGrade(target);
            if (Strings.isNotBlank((CharSequence)targetGrade)) {
                tmp_grade = targetGrade;
            }
            if (Strings.isNotBlank((CharSequence)(sourceGrade = this.extractGrade(source)))) {
                tmp_grade = (String)tmp_grade + "," + sourceGrade;
            }
            if ((grades = Strings.split((String)tmp_grade)).length > 0) {
                this.limitEnrollment(true, target, grades);
            }
        } else if (ClazzRestrictionMeta.Major.equals(mergeType)) {
            List<Major> sourceCollection;
            HashSet<Major> tmp_collection = new HashSet<Major>();
            List<Major> targetCollection = this.extractMajors(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractMajors(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, (Entity[])tmp_collection.toArray(new Major[0]));
        } else if (ClazzRestrictionMeta.Level.equals(mergeType)) {
            List<EducationLevel> sourceCollection;
            HashSet<EducationLevel> tmp_collection = new HashSet<EducationLevel>();
            List<EducationLevel> targetCollection = this.extractEducations(target);
            if (CollectUtils.isNotEmpty(targetCollection)) {
                tmp_collection.addAll(targetCollection);
            }
            if (CollectUtils.isNotEmpty(sourceCollection = this.extractEducations(source))) {
                tmp_collection.addAll(sourceCollection);
            }
            this.limitEnrollment(true, target, (Entity[])tmp_collection.toArray(new EducationLevel[0]));
        } else {
            throw new RuntimeException("unsupported limit meta merge");
        }
    }

    @Override
    public List<EducationLevel> extractEducations(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<EducationLevel>>> res = this.xtractEducationLimit(teachclass);
        List levels = CollectUtils.newArrayList();
        for (Pair<Boolean, List<EducationLevel>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (EducationLevel level : (List)tmpRes._2) {
                if (levels.contains((Object)level)) continue;
                levels.add(level);
            }
        }
        return levels;
    }

    @Override
    public List<EducationLevel> extractEducations(ClazzRestriction group) {
        Pair<Boolean, List<EducationLevel>> res = this.xtractEducationLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Squad> extractSquades(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<Squad>>> res = this.xtractSquadLimit(teachclass);
        List squades = CollectUtils.newArrayList();
        for (Pair<Boolean, List<Squad>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (Squad squad : (List)tmpRes._2) {
                if (squades.contains(squad)) continue;
                squades.add(squad);
            }
        }
        return squades;
    }

    @Override
    public List<Squad> extractSquades(ClazzRestriction group) {
        Pair<Boolean, List<Squad>> res = this.xtractSquadLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public String extractGrade(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<String>>> res = this.xtractGradeLimit(teachclass);
        Set grades = CollectUtils.newHashSet();
        for (Pair<Boolean, List<String>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            grades.addAll((Collection)tmpRes._2);
        }
        Object grade = "";
        for (String str : grades) {
            if (Strings.isNotEmpty((CharSequence)grade)) {
                grade = (String)grade + ",";
            }
            grade = (String)grade + str;
        }
        return grade;
    }

    @Override
    public String extractGrade(ClazzRestriction group) {
        Pair<Boolean, List<String>> res = this.xtractGradeLimit(group);
        if (((Boolean)res._1).booleanValue() && CollectUtils.isNotEmpty((Collection)((Collection)res._2))) {
            return (String)((List)res._2).get(0);
        }
        return null;
    }

    @Override
    public List<StdType> extractStdTypes(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<StdType>>> res = this.xtractStdTypeLimit(teachclass);
        List stdTypes = CollectUtils.newArrayList();
        for (Pair<Boolean, List<StdType>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (StdType stdType : (List)tmpRes._2) {
                if (stdTypes.contains((Object)stdType)) continue;
                stdTypes.add(stdType);
            }
        }
        return stdTypes;
    }

    @Override
    public List<StdType> extractStdTypes(ClazzRestriction group) {
        Pair<Boolean, List<StdType>> res = this.xtractStdTypeLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Major> extractMajors(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<Major>>> res = this.xtractMajorLimit(teachclass);
        List majors = CollectUtils.newArrayList();
        for (Pair<Boolean, List<Major>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (Major major : (List)tmpRes._2) {
                if (majors.contains((Object)major)) continue;
                majors.add(major);
            }
        }
        return majors;
    }

    @Override
    public List<Major> extractMajors(ClazzRestriction group) {
        Pair<Boolean, List<Major>> res = this.xtractMajorLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Direction> extractDirections(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<Direction>>> res = this.xtractDirectionLimit(teachclass);
        List directions = CollectUtils.newArrayList();
        for (Pair<Boolean, List<Direction>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (Direction direction : (List)tmpRes._2) {
                if (directions.contains((Object)direction)) continue;
                directions.add(direction);
            }
        }
        return directions;
    }

    @Override
    public List<Direction> extractDirections(ClazzRestriction group) {
        Pair<Boolean, List<Direction>> res = this.xtractDirectionLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Department> extractAttendDeparts(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<Department>>> res = this.xtractAttendDepartLimit(teachclass);
        List departments = CollectUtils.newArrayList();
        for (Pair<Boolean, List<Department>> tmpRes : res.values()) {
            if (!((Boolean)tmpRes._1).booleanValue()) continue;
            for (Department department : (List)tmpRes._2) {
                if (departments.contains(department)) continue;
                departments.add(department);
            }
        }
        return departments;
    }

    @Override
    public List<Department> extractAttendDeparts(ClazzRestriction group) {
        Pair<Boolean, List<Department>> res = this.xtractAttendDepartLimit(group);
        if (((Boolean)res._1).booleanValue()) {
            return (List)res._2;
        }
        return CollectUtils.newArrayList();
    }

    @Override
    @Deprecated
    public Gender extractGender(Enrollment teachclass) {
        List<ClazzRestriction> groups = teachclass.getRestrictions();
        for (ClazzRestriction group : groups) {
            if (!group.isPrime()) continue;
            for (ClazzRestrictionItem item : group.getItems()) {
                if (!ClazzRestrictionMeta.Gender.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
                return (Gender)((Object)this.entityDao.get(Gender.class, (Serializable[])Strings.splitToInt((String)item.getContents())).get(0));
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Gender extractGender(ClazzRestriction group) {
        if (group == null) {
            return null;
        }
        for (ClazzRestrictionItem item : group.getItems()) {
            if (!ClazzRestrictionMeta.Gender.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return (Gender)((Object)this.entityDao.get(Gender.class, (Serializable[])Strings.splitToInt((String)item.getContents())).get(0));
        }
        return null;
    }

    @Override
    public RestrictionBuilder builder() {
        return new DefaultRestrictionBuilder();
    }

    private RestrictionBuilder builder(ClazzRestriction group) {
        return new DefaultRestrictionBuilder(group);
    }

    @Override
    public RestrictionBuilder builder(Enrollment teachclass) {
        Enrollment clb = teachclass;
        ClazzRestriction group = clb.getOrCreateDefautRestriction();
        return new DefaultRestrictionBuilder(group);
    }

    @Override
    public Set<CourseTaker> extractLonelyTakers(Enrollment teachclass) {
        Set<CourseTaker> takers = teachclass.getCourseTakers();
        List<Squad> squades = this.extractSquades(teachclass);
        HashSet<CourseTaker> lonelyTakers = new HashSet<CourseTaker>();
        for (CourseTaker taker : takers) {
            boolean lonely = true;
            for (Squad squad : squades) {
                if (!squad.equals(taker.getStd().getSquad())) continue;
                lonely = false;
                break;
            }
            if (!lonely) continue;
            lonelyTakers.add(taker);
        }
        return lonelyTakers;
    }

    @Override
    public Set<CourseTaker> extractPossibleCourseTakers(Clazz clazz) {
        Enrollment teachclass = clazz.getEnrollment();
        TreeSet<CourseTaker> possibleTakers = new TreeSet<CourseTaker>(new Comparator<CourseTaker>(){

            @Override
            public int compare(CourseTaker o1, CourseTaker o2) {
                return o1.getStd().getCode().compareTo(o2.getStd().getCode());
            }
        });
        if (CollectUtils.isNotEmpty(teachclass.getCourseTakers())) {
            possibleTakers.addAll(teachclass.getCourseTakers());
            return possibleTakers;
        }
        List<Squad> squades = this.extractSquades(teachclass);
        ElectionMode eleMode = new ElectionMode();
        eleMode.setId(1);
        for (Squad squad : squades) {
            for (Student std : squad.getStudents(clazz.getSemester().getBeginOn())) {
                CourseTaker taker = new CourseTaker(clazz, std, new CourseTakeType(1));
                taker.setCourseType(clazz.getCourseType());
                taker.setElectionMode(eleMode);
                possibleTakers.add(taker);
            }
        }
        return possibleTakers;
    }

    @Override
    public void limitEnrollment(boolean inclusive, Enrollment teachclass, String ... grades) {
        if (grades.length > 0) {
            Enrollment clb = teachclass;
            ClazzRestriction group = clb.getOrCreateDefautRestriction();
            RestrictionBuilder builder = this.builder(group);
            builder.clear(ClazzRestrictionMeta.Grade);
            if (inclusive) {
                builder.inGrades(grades);
            } else {
                builder.notInGrades(grades);
            }
        }
    }

    @Override
    public <T extends Entity<?>> void limitEnrollment(boolean inclusive, Enrollment teachclass, T ... entities) {
        if (entities.length > 0) {
            Enrollment clb = teachclass;
            ClazzRestriction group = clb.getOrCreateDefautRestriction();
            RestrictionBuilder builder = this.builder(group);
            T first = entities[0];
            if (first instanceof Squad) {
                builder.clear(ClazzRestrictionMeta.Squad);
            } else if (first instanceof StdType) {
                builder.clear(ClazzRestrictionMeta.StdType);
            } else if (first instanceof Major) {
                builder.clear(ClazzRestrictionMeta.Major);
            } else if (first instanceof Direction) {
                builder.clear(ClazzRestrictionMeta.Direction);
            } else if (first instanceof Department) {
                builder.clear(ClazzRestrictionMeta.Department);
            } else if (first instanceof EducationLevel) {
                builder.clear(ClazzRestrictionMeta.Level);
            } else if (first instanceof Gender) {
                builder.clear(ClazzRestrictionMeta.Gender);
            } else if (first instanceof EducationType) {
                builder.clear(ClazzRestrictionMeta.EduType);
            } else {
                throw new RuntimeException("not supported limit meta class " + first.getClass().getName());
            }
            if (inclusive) {
                builder.in((Entity[])entities);
            } else {
                builder.notIn((Entity[])entities);
            }
        }
    }

    private Pair<Boolean, List<?>> xtractLimitDirtyWork(ClazzRestriction group, ClazzRestrictionMeta limitMeta) {
        if (group == null) {
            return new Pair(null, (Object)CollectUtils.newArrayList());
        }
        for (ClazzRestrictionItem item : group.getItems()) {
            if (ClazzRestrictionMeta.Level.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Level.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(EducationLevel.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Squad.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Squad.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Squad.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Department.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Department.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Major.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Major.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Major.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Direction.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Direction.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Direction.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.StdType.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.StdType.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Grade.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Grade.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), Arrays.asList(Strings.split((String)item.getContents())));
            }
            if (ClazzRestrictionMeta.Gender.equals((Object)limitMeta)) {
                if (!ClazzRestrictionMeta.Gender.equals((Object)item.getMeta())) continue;
                return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Gender.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
            }
            if (!ClazzRestrictionMeta.EduType.equals((Object)limitMeta) || !ClazzRestrictionMeta.EduType.equals((Object)item.getMeta())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(EducationType.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, (Object)CollectUtils.newArrayList());
    }

    private Map<ClazzRestriction, Pair<Boolean, List<?>>> xtractLimitDirtyWork(Enrollment teachclass, ClazzRestrictionMeta limitMeta) {
        List<ClazzRestriction> groups = teachclass.getRestrictions();
        Map groupDatas = CollectUtils.newHashMap();
        for (ClazzRestriction group : groups) {
            if (!group.isPrime()) continue;
            groupDatas.put(group, this.xtractLimitDirtyWork(group, limitMeta));
        }
        return groupDatas;
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<EducationLevel>>> xtractEducationLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.Level);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<EducationLevel>> xtractEducationLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Level);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<Squad>>> xtractSquadLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.Squad);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<Squad>> xtractSquadLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Squad);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<Department>>> xtractAttendDepartLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.Department);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<Department>> xtractAttendDepartLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Department);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<Direction>>> xtractDirectionLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.Direction);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<Direction>> xtractDirectionLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Direction);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<String>>> xtractGradeLimit(Enrollment teachclass) {
        List<ClazzRestriction> groups = teachclass.getRestrictions();
        Map groupDatas = CollectUtils.newHashMap();
        for (ClazzRestriction group : groups) {
            if (!group.isPrime()) continue;
            groupDatas.put(group, this.xtractGradeLimit(group));
        }
        return groupDatas;
    }

    @Override
    public Pair<Boolean, List<String>> xtractGradeLimit(ClazzRestriction group) {
        for (ClazzRestrictionItem item : group.getItems()) {
            if (!ClazzRestrictionMeta.Grade.equals((Object)item.getMeta())) continue;
            return new Pair((Object)item.isIncluded(), (Object)CollectUtils.newArrayList((Object[])new String[]{item.getContents()}));
        }
        return new Pair(null, new ArrayList());
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<Major>>> xtractMajorLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.Major);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<Major>> xtractMajorLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Major);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public Map<ClazzRestriction, Pair<Boolean, List<StdType>>> xtractStdTypeLimit(Enrollment teachclass) {
        Map<ClazzRestriction, Pair<Boolean, List<?>>> tmpRes = this.xtractLimitDirtyWork(teachclass, ClazzRestrictionMeta.StdType);
        Map results = CollectUtils.newHashMap();
        for (Map.Entry<ClazzRestriction, Pair<Boolean, List<?>>> tmpEntrySet : tmpRes.entrySet()) {
            Pair<Boolean, List<?>> tmpPair = tmpEntrySet.getValue();
            results.put(tmpEntrySet.getKey(), new Pair((Object)((Boolean)tmpPair._1), (Object)((List)tmpPair._2)));
        }
        return results;
    }

    @Override
    public Pair<Boolean, List<StdType>> xtractStdTypeLimit(ClazzRestriction group) {
        Pair<Boolean, List<?>> tmpRes = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.StdType);
        return new Pair((Object)((Boolean)tmpRes._1), (Object)((List)tmpRes._2));
    }

    @Override
    public boolean isAutoName(Clazz clazz) {
        boolean isAutoName = true;
        if (clazz.getId() != null) {
            String teachclassName = clazz.getClazzName();
            String autoName = this.teachclassNameStrategy.genName(clazz);
            if (teachclassName != null && !teachclassName.equals(autoName)) {
                isAutoName = false;
            }
        }
        return isAutoName;
    }

    @Override
    public RestrictionPair xtractLimitGroup(ClazzRestriction group) {
        RestrictionPair pair = new RestrictionPair(group);
        Pair<Boolean, List<?>> gradeLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Grade);
        if (gradeLimit._1 != null) {
            pair.setGradeLimit(gradeLimit);
        }
        Pair<Boolean, List<?>> stdTypeLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.StdType);
        if (stdTypeLimit._1 != null) {
            pair.setStdTypeLimit(stdTypeLimit);
        }
        Pair<Boolean, List<?>> genderLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Gender);
        if (genderLimit._1 != null) {
            pair.setGenderLimit(genderLimit);
        }
        Pair<Boolean, List<?>> departLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Department);
        if (departLimit._1 != null) {
            pair.setDepartmentLimit(departLimit);
        }
        Pair<Boolean, List<?>> majorLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Major);
        if (majorLimit._1 != null) {
            pair.setMajorLimit(majorLimit);
        }
        Pair<Boolean, List<?>> directionLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Direction);
        if (directionLimit._1 != null) {
            pair.setDirectionLimit(directionLimit);
        }
        Pair<Boolean, List<?>> squadLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Squad);
        if (squadLimit._1 != null) {
            pair.setSquadLimit(squadLimit);
        }
        Pair<Boolean, List<?>> levelLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.Level);
        if (levelLimit._1 != null) {
            pair.setLevelLimit(levelLimit);
        }
        Pair<Boolean, List<?>> eduTypeLimit = this.xtractLimitDirtyWork(group, ClazzRestrictionMeta.EduType);
        if (levelLimit._1 != null) {
            pair.setEduTypeLimit(eduTypeLimit);
        }
        return pair;
    }

    public void setEnrollmentNameStrategy(ClazzNameStrategy teachclassNameStrategy) {
        this.teachclassNameStrategy = teachclassNameStrategy;
    }
}

