/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.orm.hibernate.udt.HourMinute;
import org.hibernate.annotations.Type;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.resource.model.Classroom;
import org.openurp.code.edu.model.ClassroomType;
import org.openurp.code.edu.model.ExamForm;
import org.openurp.code.edu.model.ExamType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.exam.model.ExamRoom;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.exam.model.ExamTask;
import org.openurp.edu.exam.model.PublishState;

@Entity(name="org.openurp.edu.exam.model.ExamActivity")
public class ExamActivity
extends LongIdObject {
    private static final long serialVersionUID = -6748665397101838909L;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamTask task;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Clazz clazz;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType;
    private Short examWeek;
    private Boolean centralized;
    private String examPaperNo;
    private Date examOn;
    @Type(type="org.beangle.orm.hibernate.udt.HourMinuteType")
    private HourMinute beginAt;
    @Type(type="org.beangle.orm.hibernate.udt.HourMinuteType")
    private HourMinute endAt;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamForm examForm;
    @ManyToOne(fetch=FetchType.LAZY)
    private ClassroomType roomType;
    private short examDuration;
    @Size(max=255)
    private String remark;
    private int stdCount;
    @ManyToMany
    private Set<ExamRoom> rooms = CollectUtils.newHashSet();
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private PublishState publishState = PublishState.None;
    @OneToMany(mappedBy="activity", targetEntity=ExamTaker.class)
    private List<ExamTaker> examTakers = CollectUtils.newArrayList();

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public ExamTask getTask() {
        return this.task;
    }

    public void setTask(ExamTask task) {
        this.task = task;
    }

    public Short getExamWeek() {
        return this.examWeek;
    }

    public void setExamWeek(Short examWeek) {
        this.examWeek = examWeek;
    }

    public Boolean getCentralized() {
        return this.centralized;
    }

    public void setCentralized(Boolean centralized) {
        this.centralized = centralized;
    }

    public String getExamPaperNo() {
        return this.examPaperNo;
    }

    public void setExamPaperNo(String examPaperNo) {
        this.examPaperNo = examPaperNo;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setExamTakers(List<ExamTaker> examTakers) {
        this.examTakers = examTakers;
    }

    public List<ExamTaker> getExamTakers() {
        return this.examTakers;
    }

    public List<Classroom> getClassrooms() {
        if (null == this.rooms || this.rooms.isEmpty()) {
            return Collections.emptyList();
        }
        List classrooms = CollectUtils.newArrayList();
        for (ExamRoom er : this.getRooms()) {
            classrooms.add(er.getRoom());
        }
        return classrooms;
    }

    public PublishState getPublishState() {
        return this.publishState;
    }

    public void setPublishState(PublishState publishState) {
        this.publishState = publishState;
    }

    public Date getExamOn() {
        return this.examOn;
    }

    public void setExamOn(Date examOn) {
        this.examOn = examOn;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endAt) {
        this.endAt = endAt;
    }

    public Set<ExamRoom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<ExamRoom> rooms) {
        this.rooms = rooms;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public ClassroomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(ClassroomType roomType) {
        this.roomType = roomType;
    }

    public short getExamDuration() {
        return this.examDuration;
    }

    public void setExamDuration(short examDuration) {
        this.examDuration = examDuration;
    }

    public ExamForm getExamForm() {
        return this.examForm;
    }

    public void setExamForm(ExamForm examForm) {
        this.examForm = examForm;
    }
}

