/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.Operation;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamType;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.CourseGradeSetting;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.service.CourseGradePublishListener;
import org.openurp.edu.grade.course.service.CourseGradeSettings;

public class ExamTakerGeneratePublishListener
extends BaseServiceImpl
implements CourseGradePublishListener {
    private CourseGradeSettings settings;
    private String[] forbiddenCourseNames = new String[0];
    private String[] forbiddenCourseTypeNames = new String[0];
    private String[] forbiddenCourseTakeTypeNames = new String[0];
    private static final ExamType Makeup = new ExamType(ExamType.MAKEUP);
    private static final ExamType Delay = new ExamType(ExamType.DELAY);

    @Override
    public List<Operation> onPublish(Collection<CourseGrade> grades, CourseGradeState gradeState, GradeType[] gradeTypes) {
        List operations = CollectUtils.newArrayList();
        boolean hasEndGa = false;
        for (GradeType gradeType : gradeTypes) {
            if (!((Integer)gradeType.getId()).equals(GradeType.GA_ID)) continue;
            hasEndGa = true;
            break;
        }
        if (!hasEndGa) {
            return operations;
        }
        if (this.isClazzForbidden(gradeState.getClazz())) {
            return operations;
        }
        CourseGradeSetting setting = this.settings.getSetting(gradeState.getClazz().getProject());
        Map<Student, ExamTaker> examTakers = this.getExamTakers(gradeState.getClazz());
        for (CourseGrade grade : grades) {
            operations.addAll(this.publishOneGrade(grade, setting, gradeTypes, examTakers));
        }
        return operations;
    }

    @Override
    public List<Operation> onPublish(CourseGrade grade, GradeType[] gradeTypes) {
        List operations = CollectUtils.newArrayList();
        boolean hasGa = false;
        for (GradeType gradeType : gradeTypes) {
            if (!((Integer)gradeType.getId()).equals(GradeType.GA_ID)) continue;
            hasGa = true;
            break;
        }
        if (!hasGa) {
            return operations;
        }
        Clazz clazz = grade.getClazz();
        if (this.isClazzForbidden(clazz)) {
            return operations;
        }
        CourseGradeSetting setting = this.settings.getSetting(clazz.getProject());
        Map<Student, ExamTaker> examTakers = this.getExamTakers(clazz, grade.getStd());
        operations.addAll(this.publishOneGrade(grade, setting, gradeTypes, examTakers));
        return operations;
    }

    protected boolean isClazzForbidden(Clazz clazz) {
        if (null != clazz) {
            for (String courseName : this.forbiddenCourseNames) {
                if (!clazz.getCourse().getName().contains(courseName)) continue;
                return true;
            }
            for (String courseTypeName : this.forbiddenCourseTypeNames) {
                if (!clazz.getCourseType().getName().contains(courseTypeName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCourseTakeTypeForbidden(CourseGrade grade) {
        for (String takeTypeName : this.forbiddenCourseTakeTypeNames) {
            if (!grade.getCourseTakeType().getName().contains(takeTypeName)) continue;
            return true;
        }
        return false;
    }

    protected Integer getMakeupOrDelayExamTypeId(CourseGradeSetting setting, ExamGrade endGrade) {
        if (this.isCourseTakeTypeForbidden(endGrade.getCourseGrade())) {
            return null;
        }
        ExamStatus examStatus = endGrade.getExamStatus();
        if (examStatus.isHasDeferred()) {
            return ExamType.DELAY;
        }
        if (setting.getNoMakeupTakeTypes().contains((Object)endGrade.getCourseGrade().getCourseTakeType())) {
            return null;
        }
        if (setting.getNoMakeupExamStatuses().contains((Object)examStatus)) {
            return null;
        }
        return ExamType.MAKEUP;
    }

    private Map<Student, ExamTaker> getExamTakers(Clazz clazz) {
        OqlBuilder builder = OqlBuilder.from(ExamTaker.class, (String)"examTaker");
        builder.where("examTaker.clazz=:clazz and examTaker.examType in (:examTypes)", (Object)clazz, (Object)new ExamType[]{Makeup, Delay});
        List examTakers = this.entityDao.search((QueryBuilder)builder);
        Map takers = CollectUtils.newHashMap();
        for (ExamTaker examTaker : examTakers) {
            takers.put(examTaker.getStd(), examTaker);
        }
        return takers;
    }

    private Map<Student, ExamTaker> getExamTakers(Clazz clazz, Student std) {
        OqlBuilder builder = OqlBuilder.from(ExamTaker.class, (String)"examTaker");
        builder.where("examTaker.std=:std and examTaker.clazz=:clazz and examTaker.examType in (:examTypes) and examTaker.activity is null", (Object)std, (Object)clazz, (Object)new ExamType[]{Makeup, Delay}, new Object[0]);
        List examTakers = this.entityDao.search((QueryBuilder)builder);
        Map takers = CollectUtils.newHashMap();
        for (ExamTaker examTaker : examTakers) {
            takers.put(examTaker.getStd(), examTaker);
        }
        return takers;
    }

    public List<Operation> publishOneGrade(CourseGrade grade, CourseGradeSetting setting, GradeType[] gradeTypes, Map<Student, ExamTaker> examTakers) {
        List operations = CollectUtils.newArrayList();
        ExamGrade endGrade = grade.getExamGrade(new GradeType(GradeType.END_ID));
        if (null == endGrade) {
            return operations;
        }
        Clazz clazz = grade.getClazz();
        Student std = grade.getStd();
        ExamTaker taker = null;
        if (!grade.isPassed()) {
            Integer examTypeId = this.getMakeupOrDelayExamTypeId(setting, endGrade);
            if (null != examTypeId) {
                taker = this.getOrCreateExamTaker(std, clazz, new ExamType(examTypeId), examTakers);
            }
            if (null == taker) {
                this.addRemoveExamTakers(operations, std, examTakers, Makeup, Delay);
            } else {
                operations.addAll(Operation.saveOrUpdate((Object[])new Object[]{taker}).build());
                if (taker.getExamType().equals((Object)Makeup)) {
                    this.addRemoveExamTakers(operations, std, examTakers, Delay);
                }
                if (taker.getExamType().equals((Object)Delay)) {
                    this.addRemoveExamTakers(operations, std, examTakers, Makeup);
                }
            }
        } else {
            if (null != grade.getExamGrade(new GradeType(GradeType.DELAY_ID))) {
                this.addRemoveExamTakers(operations, std, examTakers, Makeup);
            }
            if (null != grade.getGrade(new GradeType(GradeType.MAKEUP_GA_ID))) {
                this.addRemoveExamTakers(operations, std, examTakers, Delay);
            }
        }
        return operations;
    }

    private void addRemoveExamTakers(List<Operation> operations, Student std, Map<Student, ExamTaker> examTakers, ExamType ... examTypes) {
        ExamTaker taker = examTakers.get(std);
        if (null != taker) {
            for (ExamType examType : examTypes) {
                if (!taker.getExamType().equals((Object)examType)) continue;
                operations.addAll(Operation.remove((Object[])new Object[]{taker}).build());
            }
        }
    }

    private ExamTaker getOrCreateExamTaker(Student std, Clazz clazz, ExamType examType, Map<Student, ExamTaker> examTakers) {
        ExamTaker taker = examTakers.get(std);
        if (null == taker) {
            taker = new ExamTaker();
            taker.setStd(std);
            taker.setClazz(clazz);
            taker.setSemester(clazz.getSemester());
            taker.setExamType(examType);
            taker.setExamStatus(new ExamStatus(ExamStatus.NORMAL));
        }
        return taker;
    }

    public void setForbiddenCourseNames(String names) {
        this.forbiddenCourseNames = Strings.split((String)names, (String)",");
        if (null == this.forbiddenCourseNames) {
            this.forbiddenCourseNames = new String[0];
        }
    }

    public void setForbiddenCourseTypeNames(String names) {
        this.forbiddenCourseTypeNames = Strings.split((String)names, (String)",");
        if (null == this.forbiddenCourseTypeNames) {
            this.forbiddenCourseTypeNames = new String[0];
        }
    }

    public void setForbiddenCourseTakeTypeNames(String names) {
        this.forbiddenCourseTakeTypeNames = Strings.split((String)names, (String)",");
        if (null == this.forbiddenCourseTakeTypeNames) {
            this.forbiddenCourseTakeTypeNames = new String[0];
        }
    }

    public void setSettings(CourseGradeSettings settings) {
        this.settings = settings;
    }
}

