/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.GaGrade;
import org.openurp.edu.grade.course.service.GradeRateService;
import org.openurp.edu.grade.course.service.ScoreConverter;
import org.openurp.edu.grade.course.service.impl.GradeFilter;

public class MakeupGradeFilter
implements GradeFilter {
    private GradeRateService gradeRateService;

    @Override
    public List<CourseGrade> filter(List<CourseGrade> grades) {
        List gradeList = CollectUtils.newArrayList();
        for (CourseGrade courseGrade : grades) {
            boolean finded = false;
            for (GaGrade gaGrade : courseGrade.getGaGrades()) {
                if (null == gaGrade.getGradeType() || !gaGrade.getGradeType().isGa()) continue;
                CourseGrade newGrade = (CourseGrade)Model.newInstance(CourseGrade.class);
                newGrade.setStd(courseGrade.getStd());
                newGrade.setSemester(courseGrade.getSemester());
                newGrade.setClazz(courseGrade.getClazz());
                newGrade.setCourse(courseGrade.getCourse());
                newGrade.setCourseType(courseGrade.getCourseType());
                newGrade.setCrn(courseGrade.getCrn());
                newGrade.setCourseType(courseGrade.getCourseType());
                newGrade.setCourseTakeType(courseGrade.getCourseTakeType());
                newGrade.setFreeListening(courseGrade.isFreeListening());
                newGrade.setScore(gaGrade.getScore());
                newGrade.setPassed(gaGrade.isPassed());
                newGrade.setGradingMode(gaGrade.getGradingMode());
                ScoreConverter converter = this.gradeRateService.getConverter(courseGrade.getProject(), gaGrade.getGradingMode());
                newGrade.setGp(converter.calcGp(newGrade.getScore()));
                finded = true;
                gradeList.add(newGrade);
            }
            if (finded) continue;
            gradeList.add(courseGrade);
        }
        return gradeList;
    }

    public void setGradeRateService(GradeRateService gradeRateService) {
        this.gradeRateService = gradeRateService;
    }
}

