/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service;

import java.time.LocalTime;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.lang.Throwables;
import org.hibernate.SessionFactory;
import org.openurp.edu.grade.plan.service.AutoBatchAuditor;
import org.openurp.edu.grade.plan.service.PlanAuditService;
import org.openurp.edu.grade.plan.service.observers.PlanAuditPersistObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditJobStarter
implements Initializing {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory;
    protected EntityDao entityDao;
    private PlanAuditService planAuditService;
    private PlanAuditPersistObserver planAuditPersistObserver;
    private static final long refreshInterval = 3600000L;

    public void init() throws Exception {
    }

    public void init1() throws Exception {
        System.out.println("gew job starting...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("gew job started");
                    LocalTime startTime = LocalTime.of(8, 0, 0);
                    LocalTime endTime = LocalTime.of(22, 0, 0);
                    while (true) {
                        LocalTime now;
                        if ((now = LocalTime.now()).isAfter(startTime) && now.isBefore(endTime)) {
                            AutoBatchAuditor auditor = new AutoBatchAuditor();
                            auditor.setPlanAuditPersistObserver(AuditJobStarter.this.planAuditPersistObserver);
                            auditor.setPlanAuditService(AuditJobStarter.this.planAuditService);
                            auditor.setEntityDao(AuditJobStarter.this.entityDao);
                            auditor.setSessionFactory(AuditJobStarter.this.sessionFactory);
                            auditor.execute();
                        }
                        Thread.sleep(3600000L);
                    }
                }
                catch (InterruptedException e) {
                    AuditJobStarter.this.logger.error(Throwables.getStackTrace((Throwable)e));
                    return;
                }
            }
        }).start();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setPlanAuditService(PlanAuditService planAuditService) {
        this.planAuditService = planAuditService;
    }

    public void setPlanAuditPersistObserver(PlanAuditPersistObserver planAuditPersistObserver) {
        this.planAuditPersistObserver = planAuditPersistObserver;
    }
}

