/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.transcript.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.CourseGradeProvider;
import org.openurp.edu.grade.course.service.impl.GradeFilter;
import org.openurp.edu.grade.course.service.impl.GradeFilterRegistry;
import org.openurp.edu.grade.transcript.service.TranscriptDataProvider;

public class TranscriptPublishedGradeProvider
implements TranscriptDataProvider {
    private GradeFilterRegistry gradeFilterRegistry;
    private CourseGradeProvider courseGradeProvider;

    @Override
    public String getDataName() {
        return "grades";
    }

    @Override
    public Object getDatas(List<Student> stds, Map<String, String> options) {
        Map datas = CollectUtils.newHashMap();
        List<GradeFilter> matched = this.getFilters(options);
        Map<Student, List<CourseGrade>> gradeMap = this.courseGradeProvider.getPublished(stds, new Semester[0]);
        for (Student std : stds) {
            List<CourseGrade> grades = gradeMap.get(std);
            for (GradeFilter filter : matched) {
                grades = filter.filter(grades);
            }
            datas.put(std, grades);
        }
        return datas;
    }

    protected List<GradeFilter> getFilters(Map<String, String> options) {
        if (null == options || options.isEmpty()) {
            return Collections.emptyList();
        }
        return this.gradeFilterRegistry.getFilters(options.get("grade.filters"));
    }

    public void setGradeFilterRegistry(GradeFilterRegistry gradeFilterRegistry) {
        this.gradeFilterRegistry = gradeFilterRegistry;
    }

    public void setCourseGradeProvider(CourseGradeProvider courseGradeProvider) {
        this.courseGradeProvider = courseGradeProvider;
    }
}

