/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.dao.hibernate;

import java.util.Date;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.model.User;
import org.openurp.edu.program.app.dao.ExecutivePlanCourseGroupModifyAuditDao;
import org.openurp.edu.program.app.model.ExecutiveCourseGroupModify;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.ExecutivePlanAuditException;

public class ExecutivePlanCourseGroupModifyAuditDaoHibernate
extends HibernateEntityDao
implements ExecutivePlanCourseGroupModifyAuditDao {
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void rejected(ExecutiveCourseGroupModify apply, User assessor) {
        apply.setAssessor(assessor);
        apply.setFlag(ExecutiveCourseGroupModify.REFUSE);
        apply.setReplyDate(new Date());
        this.saveOrUpdate(new Object[]{apply});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void approved(ExecutiveCourseGroupModify apply, User assessor) throws ExecutivePlanAuditException {
        ExecutivePlan plan = (ExecutivePlan)this.get(ExecutivePlan.class, apply.getExecutivePlan().getId());
        if (plan == null) {
            throw new ExecutivePlanAuditException("\u60a8\u8981\u4fee\u6539\u7684\u4e13\u4e1a\u57f9\u517b\u8ba1\u5212\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002");
        }
        ExecutiveCourseGroup parent = null;
        if (apply.getNewPlanCourseGroup() != null && apply.getNewPlanCourseGroup().getParent() != null && null == (parent = (ExecutiveCourseGroup)this.get(ExecutiveCourseGroup.class, apply.getNewPlanCourseGroup().getParent().getId()))) {
            throw new ExecutivePlanAuditException("\u7236\u8bfe\u7a0b\u7ec4\u5df2\u4e0d\u5b58\u5728");
        }
        ExecutiveCourseGroup courseGroup = new ExecutiveCourseGroup();
        if (ExecutiveCourseGroupModify.DELETE.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getOldPlanCourseGroup().getCourseType().getId();
            ExecutiveCourseGroup group = (ExecutiveCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (group == null) throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728:" + apply.getOldPlanCourseGroup().getCourseType().getName());
            this.planCourseGroupCommonDao.removeCourseGroup(group);
        } else if (ExecutiveCourseGroupModify.ADD.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getNewPlanCourseGroup().getCourseType().getId();
            ExecutiveCourseGroup group = (ExecutiveCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (group != null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u7ec4\u5df2\u5b58\u5728:" + apply.getNewPlanCourseGroup().getCourseType().getName());
            }
            group = new ExecutiveCourseGroup();
            group.setPlan(plan);
            group.setCourseType(apply.getNewPlanCourseGroup().getCourseType());
            group.setCourseCount(apply.getNewPlanCourseGroup().getCourseCount());
            group.setTermCredits(apply.getNewPlanCourseGroup().getTermCredits());
            group.setCredits(apply.getNewPlanCourseGroup().getCredits());
            group.setSubCount(apply.getNewPlanCourseGroup().getSubCount());
            group.setRemark(apply.getNewPlanCourseGroup().getRemark());
            group.setIndexno("--");
            this.planCourseGroupCommonDao.addCourseGroupToPlan(group, parent, plan);
        } else if (ExecutiveCourseGroupModify.MODIFY.equals(apply.getRequisitionType())) {
            Integer typeId = (Integer)apply.getOldPlanCourseGroup().getCourseType().getId();
            ExecutiveCourseGroup oldGroup = (ExecutiveCourseGroup)this.planCourseGroupCommonDao.getCourseGroupByCourseType(courseGroup, (Long)plan.getId(), typeId);
            if (oldGroup == null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728:" + apply.getOldPlanCourseGroup().getCourseType().getName());
            }
            this.planCourseGroupCommonDao.updateCourseGroupParent(oldGroup, parent, plan);
            oldGroup.setCourseType(apply.getNewPlanCourseGroup().getCourseType());
            oldGroup.setCourseCount(apply.getNewPlanCourseGroup().getCourseCount());
            oldGroup.setTermCredits(apply.getNewPlanCourseGroup().getTermCredits());
            oldGroup.setCredits(apply.getNewPlanCourseGroup().getCredits());
            oldGroup.setSubCount(apply.getNewPlanCourseGroup().getSubCount());
            oldGroup.setRemark(apply.getNewPlanCourseGroup().getRemark());
            this.planCourseGroupCommonDao.saveOrUpdateCourseGroup(oldGroup);
            this.saveOrUpdate(new Object[]{plan});
        }
        apply.setAssessor(assessor);
        apply.setFlag(ExecutiveCourseGroupModify.ACCEPT);
        apply.setReplyDate(new Date());
        this.saveOrUpdate(new Object[]{apply});
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

