/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Project;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Grade;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.model.AbstractCourseSubstitution;

@Entity(name="org.openurp.edu.program.model.MajorAlternativeCourse")
@Table(name="major_alt_courses")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class MajorAlternativeCourse
extends AbstractCourseSubstitution {
    private static final long serialVersionUID = 5820298588618272410L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Grade fromGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Grade toGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @Size(max=300)
    private String remark;
    @ManyToMany
    @JoinColumn(nullable=false)
    @JoinTable(name="major_alt_courses_olds", joinColumns={@JoinColumn(name="major_alt_course_id")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Course> olds = CollectUtils.newHashSet();
    @ManyToMany
    @JoinColumn(nullable=false)
    @JoinTable(name="major_alt_courses_news", joinColumns={@JoinColumn(name="major_alt_course_id")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Course> news = CollectUtils.newHashSet();

    public Grade getFromGrade() {
        return this.fromGrade;
    }

    public void setFromGrade(Grade fromGrade) {
        this.fromGrade = fromGrade;
    }

    public Grade getToGrade() {
        return this.toGrade;
    }

    public void setToGrade(Grade toGrade) {
        this.toGrade = toGrade;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    @Override
    public Set<Course> getOlds() {
        return this.olds;
    }

    @Override
    public void setOlds(Set<Course> olds) {
        this.olds = olds;
    }

    @Override
    public Set<Course> getNews() {
        return this.news;
    }

    @Override
    public void setNews(Set<Course> news) {
        this.news = news;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

