/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.lang.BitStrings;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.openurp.base.edu.model.CourseUnit;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.service.OccupyProcessor;
import org.openurp.base.service.StdOccupyProvider;
import org.openurp.base.service.wrapper.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStdOccupyProvider
implements StdOccupyProvider {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EntityDao entityDao;
    protected Semester semester;

    public void setEntityService(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    protected Map executeOccupyQuery(QueryBuilder query, TimeZone zone, OccupyProcessor processor) {
        Long st = System.currentTimeMillis();
        HashMap<String, Number> params = query.getParams();
        if (null == params) {
            params = new HashMap<String, Number>();
        }
        HashMap occupis = new HashMap();
        for (WeekDay week : zone.getWeeks()) {
            HashMap weekOccupy = new HashMap();
            for (CourseUnit unit : zone.getUnits()) {
                for (String weekState : zone.getWeekStates()) {
                    params.put("weekId", new Integer(week.getId()));
                    params.put("startTime", (Number)unit.getBeginAt());
                    params.put("endTime", (Number)unit.getEndAt());
                    params.put("weekState", BitStrings.binValueOf((String)weekState));
                    query.params(params);
                    List datas = this.entityDao.search(query);
                    if (datas.isEmpty()) continue;
                    processor.process(weekOccupy, unit, datas);
                }
            }
            if (weekOccupy.isEmpty()) continue;
            occupis.put(week, weekOccupy);
        }
        this.logger.info("occupy query consume time {} millis", (Object)(System.currentTimeMillis() - st));
        return occupis;
    }
}

