/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.time;

import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.i18n.TextResource;
import org.openurp.base.time.NumberRange;

public class NumberRangeFormatter {
    private static final NumberRangeFormatter me = new NumberRangeFormatter();

    public static NumberRangeFormatter getInstance() {
        return me;
    }

    public String format(NumberRange pattern, TextResource textResource, boolean hasNext) {
        StringBuilder sb = new StringBuilder();
        if (pattern.getStart().equals(pattern.getEnd())) {
            sb.append(pattern.getStart());
        } else {
            sb.append('[').append(pattern.getStart()).append('-').append(pattern.getEnd()).append(']');
        }
        if (Strings.isNotBlank((CharSequence)pattern.getI18nKey())) {
            if (textResource != null) {
                sb.append(textResource.getText(pattern.getI18nKey()));
            } else {
                sb.append(pattern.getI18nKey());
            }
        }
        if (hasNext) {
            sb.append(',');
        }
        return sb.toString();
    }

    public String format(NumberRange pattern, TextResource textResource) {
        return this.format(pattern, textResource, false);
    }
}

