/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.app.model;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Objects;
import org.beangle.ems.rule.model.RuleConfig;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.ProjectBasedObject;
import org.openurp.base.edu.model.Semester;
import org.openurp.edu.clazz.app.model.enums.ElectRuleType;
import org.openurp.edu.clazz.app.model.enums.ElectionProfileType;

@Entity(name="org.openurp.edu.clazz.app.model.ElectionProfile")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class ElectionProfile
extends ProjectBasedObject<Long> {
    private static final long serialVersionUID = -6606179153423814495L;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ElectionProfileType profileType = ElectionProfileType.STD;
    @NotNull
    private String name = "";
    @NotNull
    private int turn = 1;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="STD_TYPE_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Integer> stdTypes = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="EDUCATION_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_EDUCATIONS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Integer> levels = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="DEPART_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Integer> departs = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="MAJOR_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Long> majors = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="DIRECTION_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Long> directions = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="GRADE", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<String> grades = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="STD_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Long> stds = CollectUtils.newHashSet();
    @NotNull
    private Date beginAt;
    @NotNull
    private Date endAt;
    private Date electBeginAt;
    private Date electEndAt;
    private Date withdrawBeginAt;
    private Date withdrawEndAt;
    @NotNull
    private boolean openElection;
    @NotNull
    private boolean openWithdraw;
    @NotNull
    private String notice;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="RULE_CONFIG_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_GENERAL_CFGS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<RuleConfig> generalConfigs = CollectUtils.newHashSet();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="RULE_CONFIG_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_ELECT_CFGS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<RuleConfig> electConfigs = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.LAZY)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="LESSON_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_ELT_LESSONS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Long> electableClazzes = CollectUtils.newHashSet();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="RULE_CONFIG_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_WD_CFGS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<RuleConfig> withdrawConfigs = CollectUtils.newHashSet();
    @ElementCollection(fetch=FetchType.LAZY)
    @JoinColumn(name="ELECTION_PROFILE_ID")
    @Column(name="LESSON_ID", nullable=false)
    @JoinTable(name="ELECTION_PROFILES_WD_LESSONS")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Long> withdrawableClazzes = CollectUtils.newHashSet();

    public ElectionProfile() {
    }

    public ElectionProfile(String beginDate, String endDate) {
        try {
            this.beginAt = DateUtils.parseDate((String)beginDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            this.endAt = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public ElectionProfile(Date beginAt, Date endAt) {
        this.beginAt = beginAt;
        this.endAt = endAt;
    }

    public Set<RuleConfig> getElectConfigs() {
        return this.electConfigs;
    }

    public void setElectConfigs(Set<RuleConfig> electConfigs) {
        this.electConfigs = electConfigs;
    }

    public Date getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(Date beginAt) {
        this.beginAt = beginAt;
    }

    public Date getEndAt() {
        return this.endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public int getTurn() {
        return this.turn;
    }

    public void setTurn(int turn) {
        this.turn = turn;
    }

    public boolean isTimeSuitable() {
        return this.beginAt.getTime() <= System.currentTimeMillis() && System.currentTimeMillis() <= this.endAt.getTime();
    }

    public boolean isTimeSuitable(Date date) {
        return this.beginAt.getTime() <= date.getTime() && date.getTime() <= this.endAt.getTime();
    }

    public boolean isElectionTimeSuitable(Date date) {
        return this.openElection && this.electBeginAt.getTime() <= date.getTime() && date.getTime() <= this.electEndAt.getTime();
    }

    public boolean isWithdrawTimeSuitable(Date date) {
        return this.openWithdraw && this.withdrawBeginAt.getTime() <= date.getTime() && date.getTime() <= this.withdrawEndAt.getTime();
    }

    public boolean isOutOfDate() {
        return System.currentTimeMillis() >= this.endAt.getTime();
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("semester", (Object)this.semester).add("turn", (Object)this.turn).add("beginAt", (Object)this.beginAt).add("endAt", (Object)this.endAt).toString();
    }

    public List<?> getCheckerConfigs() {
        return null;
    }

    public void setCheckerConfigs(List<?> checkers) {
    }

    public Set<Integer> getDeparts() {
        return this.departs;
    }

    public void setDeparts(Set<Integer> departs) {
        this.departs = departs;
    }

    public Set<String> getGrades() {
        return this.grades;
    }

    public void setGrades(Set<String> grades) {
        this.grades = grades;
    }

    public Set<Long> getDirections() {
        return this.directions;
    }

    public void setDirections(Set<Long> directions) {
        this.directions = directions;
    }

    public Set<Long> getMajors() {
        return this.majors;
    }

    public void setMajors(Set<Long> majors) {
        this.majors = majors;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public Set<Long> getStds() {
        return this.stds;
    }

    public void setStds(Set<Long> stds) {
        this.stds = stds;
    }

    public Set<Integer> getStdTypes() {
        return this.stdTypes;
    }

    public void setStdTypes(Set<Integer> stdTypes) {
        this.stdTypes = stdTypes;
    }

    public Set<Integer> getLevels() {
        return this.levels;
    }

    public void setEducations(Set<Integer> levels) {
        this.levels = levels;
    }

    public void setOpenElection(boolean openElection) {
        this.openElection = openElection;
    }

    public boolean isOpenElection() {
        return this.openElection;
    }

    public Set<RuleConfig> getWithdrawConfigs() {
        return this.withdrawConfigs;
    }

    public void setWithdrawConfigs(Set<RuleConfig> withdrawConfigs) {
        this.withdrawConfigs = withdrawConfigs;
    }

    public Date getElectBeginAt() {
        return this.electBeginAt;
    }

    public void setElectBeginAt(Date electBeginAt) {
        this.electBeginAt = electBeginAt;
    }

    public Date getElectEndAt() {
        return this.electEndAt;
    }

    public void setElectEndAt(Date electEndAt) {
        this.electEndAt = electEndAt;
    }

    public Date getWithdrawBeginAt() {
        return this.withdrawBeginAt;
    }

    public void setWithdrawBeginAt(Date withdrawBeginAt) {
        this.withdrawBeginAt = withdrawBeginAt;
    }

    public Date getWithdrawEndAt() {
        return this.withdrawEndAt;
    }

    public void setWithdrawEndAt(Date withdrawEndAt) {
        this.withdrawEndAt = withdrawEndAt;
    }

    public Set<Long> getElectableClazzes() {
        return this.electableClazzes;
    }

    public void setElectableClazzes(Set<Long> electableClazzes) {
        this.electableClazzes = electableClazzes;
    }

    public Set<Long> getWithdrawableClazzes() {
        return this.withdrawableClazzes;
    }

    public void setWithdrawableClazzes(Set<Long> withdrawableClazzes) {
        this.withdrawableClazzes = withdrawableClazzes;
    }

    public Set<RuleConfig> getGeneralConfigs() {
        return this.generalConfigs;
    }

    public void setGeneralConfigs(Set<RuleConfig> generalConfigs) {
        this.generalConfigs = generalConfigs;
    }

    public Set<RuleConfig> getConfigs(ElectRuleType type) {
        switch (type) {
            case ELECTION: {
                return this.getElectConfigs();
            }
            case WITHDRAW: {
                return this.getWithdrawConfigs();
            }
        }
        return this.getGeneralConfigs();
    }

    public boolean isOpenWithdraw() {
        return this.openWithdraw;
    }

    public void setOpenWithdraw(boolean openWithdraw) {
        this.openWithdraw = openWithdraw;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ElectionProfileType getProfileType() {
        return this.profileType;
    }

    public void setProfileType(ElectionProfileType profileType) {
        this.profileType = profileType;
    }
}

