/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.dao.hibernate.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.hibernate.Cache;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.AuditStatus;
import org.openurp.edu.clazz.dao.ClazzCRNGenerator;
import org.openurp.edu.clazz.dao.ClazzDao;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ScheduleSuggest;
import org.openurp.edu.clazz.service.ClazzFilterStrategy;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.room.model.Occupancy;
import org.openurp.edu.room.model.RoomOccupyApp;
import org.openurp.edu.textbook.model.ClazzMaterial;

public class ClazzDaoHibernate
extends HibernateEntityDao
implements ClazzDao {
    private ClazzCRNGenerator clazzCRNGenerator;

    private void evictClazzRegion() {
        Cache cache = this.sessionFactory.getCache();
        if (null != cache) {
            cache.evictEntityRegion(Clazz.class);
        }
    }

    @Override
    public Page<Clazz> getClazzesByCategory(Serializable id, ClazzFilterStrategy strategy, Semester semester, int pageNo, int pageSize) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        if (strategy.getName().equals("teacher")) {
            id = "%" + (Serializable)id + "%";
        }
        params.put("id", id);
        params.put("semesterId", semester.getId());
        String queryStr = strategy.getQueryString(null, " and task.semester.id= :semesterId ");
        List clazzes = this.search(queryStr, params, new PageLimit(pageNo, pageSize), false);
        return (Page)clazzes;
    }

    @Override
    public List<Clazz> getClazzesByCategory(Serializable id, ClazzFilterStrategy strategy, Collection<Semester> semesters) {
        Query taskQuery = strategy.createQuery(this.getSession(), "select distinct task.id from Clazz as task ", " and task.semester in (:semesters) ");
        taskQuery.setParameter("id", (Object)id);
        taskQuery.setParameterList("semesters", semesters);
        return this.get(Clazz.class, taskQuery.list());
    }

    public List<Clazz> getClazzesOfStd(Serializable stdId, List<Semester> semesters) {
        OqlBuilder queryBuilder = OqlBuilder.from(Clazz.class, (String)"clazz");
        queryBuilder.join("clazz.enrollment.courseTakers", "courseTaker");
        queryBuilder.where("courseTaker.std.id =:stdId", (Object)stdId);
        queryBuilder.where("clazz.semester in (:semesters)", semesters);
        return this.search((QueryBuilder)queryBuilder);
    }

    @Override
    public int updateClazzByCategory(String attr, Object value, Long id, ClazzFilterStrategy strategy, Semester semester) {
        this.evictClazzRegion();
        String queryStr = strategy.getQueryString("update TeachTask set " + attr + " = :value ", " and semester.id = :semesterId");
        return this.executeUpdate(queryStr, new Object[]{value, semester.getId()});
    }

    private String getUpdateQueryString(String attr, Object value, Clazz clazz, Integer[] stdTypeIds, Long[] departIds, Map<String, Object> newParamsMap) {
        OqlBuilder entityQuery = OqlBuilder.from(Clazz.class, (String)"clazz");
        entityQuery.where((Collection)Conditions.extractConditions((String)"clazz", (Entity)clazz));
        if (null != stdTypeIds && 0 != stdTypeIds.length) {
            entityQuery.where("clazz.teachclass.stdType.id in (:stdTypeIds) ", (Object)stdTypeIds);
        }
        if (null != departIds && 0 != departIds.length) {
            entityQuery.where("clazz.teachDepart.id in (:departIds) ", (Object)departIds);
        }
        StringBuffer updateSql = new StringBuffer("update " + Clazz.class.getName() + " set " + attr + "=(:" + attr + ") where id in (");
        updateSql.append(entityQuery.build().getStatement()).append(")");
        newParamsMap.put(attr, value);
        newParamsMap.putAll(entityQuery.getParams());
        return updateSql.toString();
    }

    @Override
    public int updateClazzByCriteria(String attr, Object value, Clazz clazz, Integer[] stdTypeIds, Long[] departIds) {
        this.evictClazzRegion();
        Map newParamsMap = CollectUtils.newHashMap();
        String updateSql = this.getUpdateQueryString(attr, value, clazz, stdTypeIds, departIds, newParamsMap);
        Query query = this.getSession().createQuery(updateSql);
        HibernateEntityDao.QuerySupport.setParameter((Query)query, (Map)newParamsMap);
        return query.executeUpdate();
    }

    @Override
    public int countClazz(Serializable id, ClazzFilterStrategy strategy, Semester semester) {
        Query countQuery = strategy.createQuery(this.getSession(), "select count(task.id) from " + Clazz.class.getName() + " as task ", " and task.semester.id  = :semesterId");
        if (strategy.getName().equals("teacher")) {
            id = "%" + (Serializable)id + "%";
        }
        countQuery.setParameter("id", id);
        countQuery.setParameter("semesterId", (Object)semester.getId());
        List rsList = countQuery.list();
        return ((Number)rsList.get(0)).intValue();
    }

    @Override
    public void saveMergeResult(Clazz[] clazzes, int index) {
        this.saveOrUpdate(clazzes[index]);
        for (int i = 0; i < clazzes.length; ++i) {
            if (i == index) continue;
            this.remove(clazzes[i]);
        }
    }

    @Override
    public void remove(Clazz clazz) {
        List removeEntities = CollectUtils.newArrayList();
        List<Occupancy> occupancies = this.getOccupancies(clazz);
        removeEntities.addAll(occupancies);
        List clazzMaterials = this.get(ClazzMaterial.class, "clazz", new Object[]{clazz});
        removeEntities.addAll(clazzMaterials);
        List suggests = this.get(ScheduleSuggest.class, "clazz", new Object[]{clazz});
        removeEntities.addAll(suggests);
        List examTakers = this.get(ExamTaker.class, "clazz", new Object[]{clazz});
        removeEntities.addAll(examTakers);
        List examActivities = this.get(ExamActivity.class, "clazz", new Object[]{clazz});
        removeEntities.addAll(examActivities);
        List gradeStates = this.get(CourseGradeState.class, "clazz", new Object[]{clazz});
        removeEntities.addAll(gradeStates);
        removeEntities.add(clazz);
        super.remove((Collection)removeEntities);
    }

    public List<Occupancy> getOccupancies(Clazz clazz) {
        OqlBuilder builder = OqlBuilder.from(Occupancy.class, (String)"occupancy").where("occupancy.activityId = :clazzId and occupancy.app.id in(:apps)", (Object)clazz.getId(), (Object)new Integer[]{RoomOccupyApp.COURSE, RoomOccupyApp.EXAM});
        return this.search((QueryBuilder)builder);
    }

    @Override
    public void saveGenResult(ExecutivePlan plan, Semester semester, List<Clazz> clazzes, boolean removeExists) {
        if (removeExists) {
            OqlBuilder query = OqlBuilder.from(Clazz.class, (String)"clazz");
            query.where("clazz.planId = :planId", (Object)plan.getId());
            query.where("clazz.semester=:semester", (Object)semester);
            List existsClazzes = this.search((QueryBuilder)query);
            for (Clazz clazz : existsClazzes) {
                this.remove(clazz);
            }
        }
        this.getSession().setFlushMode(FlushMode.COMMIT);
        this.clazzCRNGenerator.genClazzSeqNos(clazzes);
        for (Clazz clazz : clazzes) {
            clazz.setStatus(AuditStatus.UNSUBMITTED);
            clazz.setPlanId((Long)plan.getId());
            super.saveOrUpdate(new Object[]{clazz});
        }
    }

    @Override
    public void saveOrUpdate(Clazz clazz) {
        Iterator<ClazzRestriction> iter = clazz.getEnrollment().getRestrictions().iterator();
        while (iter.hasNext()) {
            if (!CollectUtils.isEmpty(iter.next().getItems())) continue;
            iter.remove();
        }
        this.clazzCRNGenerator.genClazzSeqNo(clazz);
        super.saveOrUpdate(new Object[]{clazz});
    }

    public void setClazzCRNGenerator(ClazzCRNGenerator clazzSeqNoGenerator) {
        this.clazzCRNGenerator = clazzSeqNoGenerator;
    }
}

