/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Objects;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.beangle.orm.hibernate.udt.WeekTimes;
import org.openurp.base.edu.model.CourseUnit;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.resource.model.Classroom;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.ScheduleSuggest;

@Entity(name="org.openurp.edu.clazz.model.ScheduleSuggestActivity")
public class ScheduleSuggestActivity
extends LongIdObject
implements Comparable<ScheduleSuggestActivity> {
    private static final long serialVersionUID = 2498530728105897805L;
    @NotNull
    @ManyToOne(targetEntity=ScheduleSuggest.class)
    protected ScheduleSuggest suggest;
    @Embedded
    protected WeekTime time;
    @ManyToOne(targetEntity=ScheduleSuggest.class)
    private Teacher teacher;
    private Classroom room;

    public ScheduleSuggestActivity() {
    }

    public ScheduleSuggestActivity(Long id) {
        super(id);
    }

    public ScheduleSuggestActivity(Teacher teacher, WeekTime time) {
        this.teacher = teacher;
        this.setTime(new WeekTime(time));
    }

    public ScheduleSuggest getSuggest() {
        return this.suggest;
    }

    public void setSuggest(ScheduleSuggest clazz) {
        this.suggest = clazz;
    }

    public WeekTime getTime() {
        return this.time;
    }

    public void setTime(WeekTime time) {
        this.time = time;
    }

    public Date getBeginAt() {
        return null;
    }

    public Date getEndAt() {
        return null;
    }

    public boolean contains(Date oneDay) {
        return false;
    }

    public String getContent() {
        return null;
    }

    public Object clone() {
        ScheduleSuggestActivity activity = new ScheduleSuggestActivity();
        activity.setTime(new WeekTime(this.getTime()));
        activity.setSuggest(this.suggest);
        activity.teacher = this.getTeacher();
        return activity;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("time", (Object)this.getTime().toString()).add("teacher", (Object)this.getTeacher()).add("id", (Object)this.id).toString();
    }

    public static List<ScheduleSuggestActivity> mergeActivities(List<ScheduleSuggestActivity> activities) {
        List mergedActivities = CollectUtils.newArrayList();
        if (CollectUtils.isEmpty(activities)) {
            return mergedActivities;
        }
        Collections.sort(activities);
        Iterator<ScheduleSuggestActivity> activityIter = activities.iterator();
        ScheduleSuggestActivity nextToBeMergedActivity = activityIter.next();
        mergedActivities.add(nextToBeMergedActivity);
        while (activityIter.hasNext()) {
            ScheduleSuggestActivity activity = activityIter.next();
            if (nextToBeMergedActivity.canMergerWith(activity)) {
                nextToBeMergedActivity.mergeWith(activity);
                continue;
            }
            if (nextToBeMergedActivity.getTime().equals((Object)activity.getTime())) {
                nextToBeMergedActivity.mergeWith(activity);
                nextToBeMergedActivity.setTeacher(activity.getTeacher());
                continue;
            }
            nextToBeMergedActivity = activity;
            mergedActivities.add(nextToBeMergedActivity);
        }
        return mergedActivities;
    }

    public boolean canMergerWith(ScheduleSuggestActivity activity) {
        if (!Objects.equals((Object)((Object)this.getTeacher()), (Object)((Object)activity.getTeacher()))) {
            return false;
        }
        return WeekTimes.canMergerWith((WeekTime)this.getTime(), (WeekTime)activity.getTime());
    }

    public void mergeWith(ScheduleSuggestActivity other) {
        WeekTimes.mergeWith((WeekTime)this.getTime(), (WeekTime)other.getTime());
    }

    @Override
    public int compareTo(ScheduleSuggestActivity other) {
        int rs = 0;
        if (rs == 0) {
            rs = this.getTime().getWeekstate().compareTo(other.getTime().getWeekstate());
        }
        if (rs == 0) {
            rs = this.getTime().getStartOn().compareTo(other.getTime().getStartOn());
        }
        if (rs == 0) {
            rs = this.getTime().getBeginAt().value - other.getTime().getBeginAt().value;
        }
        return rs;
    }

    public Set<ScheduleSuggestActivity> flatten(Map<Integer, CourseUnit> unitMap) {
        Set flattenedActivities = CollectUtils.newHashSet();
        if (null != this.teacher) {
            WeekTime flattenedTime = new WeekTime(this.time);
            flattenedActivities.add(new ScheduleSuggestActivity(this.teacher, flattenedTime));
        }
        return flattenedActivities;
    }

    public static Set<ScheduleSuggestActivity> flatten(Collection<ScheduleSuggestActivity> activities, TimeSetting timeSetting) {
        Set flattenedActivities = CollectUtils.newHashSet();
        for (ScheduleSuggestActivity activity : activities) {
            flattenedActivities.addAll(activity.flatten(timeSetting.getUnitMap()));
        }
        return flattenedActivities;
    }

    public ClazzActivity toSession() {
        ClazzActivity activity = new ClazzActivity();
        activity.setClazz(this.suggest.getClazz());
        if (null != this.teacher) {
            activity.getTeachers().add(this.teacher);
        }
        activity.setTime((WeekTime)this.time.clone());
        return activity;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Teacher teacher) {
        this.teacher = teacher;
    }

    public Classroom getRoom() {
        return this.room;
    }

    public void setRoom(Classroom room) {
        this.room = room;
    }
}

