/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.impl.GradeComparator;
import org.openurp.edu.grade.course.service.impl.GradeFilter;
import org.openurp.edu.program.model.AlternativeCourse;
import org.openurp.edu.program.plan.service.AlternativeCourseService;

public class BestGradeFilter
implements GradeFilter {
    private AlternativeCourseService alternativeCourseService;

    protected Map<Course, CourseGrade> buildGradeMap(List<CourseGrade> grades) {
        Map gradesMap = CollectUtils.newHashMap();
        CourseGrade old = null;
        for (CourseGrade grade : grades) {
            if (!GradeComparator.betterThan(grade, old = (CourseGrade)gradesMap.get(grade.getCourse()))) continue;
            gradesMap.put(grade.getCourse(), grade);
        }
        return gradesMap;
    }

    @Override
    public List<CourseGrade> filter(List<CourseGrade> grades) {
        Map<Course, CourseGrade> gradesMap = this.buildGradeMap(grades);
        List<AlternativeCourse> substituteCourses = this.getSubstituteCourses(grades);
        for (AlternativeCourse subCourse : substituteCourses) {
            if (!GradeComparator.isSubstitute(subCourse, gradesMap)) continue;
            for (Course c : subCourse.getOlds()) {
                gradesMap.remove(c);
            }
        }
        return CollectUtils.newArrayList(gradesMap.values());
    }

    private List<AlternativeCourse> getSubstituteCourses(List<CourseGrade> grades) {
        if (grades.isEmpty()) {
            return Collections.emptyList();
        }
        CourseGrade grade = grades.get(0);
        return this.alternativeCourseService.getAlternativeCourses(grade.getStd());
    }

    public final void setAlternativeCourseService(AlternativeCourseService alternativeCourseService) {
        this.alternativeCourseService = alternativeCourseService;
    }
}

