/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Map;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.program.model.AlternativeCourse;

public class GradeComparator {
    public static final boolean betterThan(CourseGrade first, CourseGrade second) {
        float score2;
        float gp2;
        if (null == second) {
            return true;
        }
        float gp1 = null == first.getGp() ? 0.0f : first.getGp().floatValue();
        int gpResult = Float.compare(gp1, gp2 = null == second.getGp() ? 0.0f : second.getGp().floatValue());
        if (0 != gpResult) {
            return gpResult > 0;
        }
        float score1 = null == first.getScore() ? 0.0f : first.getScore().floatValue();
        int scoreResult = Float.compare(score1, score2 = null == second.getScore() ? 0.0f : second.getScore().floatValue());
        if (0 != scoreResult) {
            return scoreResult > 0;
        }
        return first.isPassed();
    }

    public static boolean isSubstitute(AlternativeCourse alternative, Map<Course, CourseGrade> grades) {
        boolean existOrigGrade = false;
        float gpa1 = 0.0f;
        float ga1 = 0.0f;
        float credit1 = 0.0f;
        int passed1 = 0;
        for (Course course : alternative.getOlds()) {
            CourseGrade grade = grades.get(course);
            if (null != grade) {
                if (grade.isPassed()) {
                    ++passed1;
                }
                if (null != grade.getGp()) {
                    gpa1 += grade.getCourse().getDefaultCredits() * grade.getGp().floatValue();
                }
                if (null != grade.getScore()) {
                    ga1 = grade.getCourse().getDefaultCredits() * grade.getScore().floatValue();
                }
                existOrigGrade = true;
            }
            credit1 += course.getDefaultCredits();
        }
        boolean fullGrade2 = true;
        float gpa2 = 0.0f;
        float ga2 = 0.0f;
        float credit2 = 0.0f;
        int passed2 = 0;
        for (Course course : alternative.getNews()) {
            CourseGrade grade = grades.get(course);
            if (null != grade) {
                if (grade.isPassed()) {
                    ++passed2;
                }
                if (null != grade.getGp()) {
                    gpa2 += grade.getCourse().getDefaultCredits() * grade.getGp().floatValue();
                }
                if (null != grade.getScore()) {
                    ga2 = grade.getCourse().getDefaultCredits() * grade.getScore().floatValue();
                }
            } else {
                fullGrade2 = false;
            }
            credit2 += course.getDefaultCredits();
        }
        boolean success = false;
        if (!existOrigGrade && fullGrade2) {
            success = true;
        } else if (fullGrade2 && credit1 > 0.0f && credit2 > 0.0f) {
            int gpaCompare = 0;
            if (gpa1 > 0.0f || gpa2 > 0.0f) {
                gpaCompare = Float.compare(gpa1 / credit1, gpa2 / credit2);
            }
            if (0 == gpaCompare && (ga1 > 0.0f || ga2 > 0.0f)) {
                gpaCompare = Float.compare(ga1 / credit1, ga2 / credit2);
            }
            if (0 == gpaCompare) {
                gpaCompare = passed1 - passed2;
            }
            boolean bl = success = gpaCompare <= 0;
        }
        if (!success && existOrigGrade && fullGrade2) {
            for (Course course : alternative.getNews()) {
                grades.remove(course);
            }
        }
        return success;
    }
}

