/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.stat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.stat.CourseStdNum;
import org.openurp.edu.grade.course.service.stat.StdGrade;

public class MultiStdGrade {
    private Semester semester;
    private Squad adminClass;
    private List<Course> courses;
    private List<StdGrade> stdGrades;
    private Map<String, List<CourseGrade>> extraGradeMap = CollectUtils.newHashMap();
    private Integer maxDisplay;
    private Float ratio;

    public MultiStdGrade(Semester semester, Map<Student, List<CourseGrade>> grades, Float ratio) {
        if (grades.isEmpty()) {
            return;
        }
        this.semester = semester;
        this.ratio = ratio;
        Map gradesMap = CollectUtils.newHashMap();
        Map courseStdNumMap = CollectUtils.newHashMap();
        for (Map.Entry<Student, List<CourseGrade>> entry : grades.entrySet()) {
            List<CourseGrade> personGrades = entry.getValue();
            if (personGrades.isEmpty()) continue;
            StdGrade stdGrade = new StdGrade(entry.getKey(), personGrades, null, null);
            gradesMap.put((Long)entry.getKey().getId(), stdGrade);
            for (CourseGrade grade : entry.getValue()) {
                CourseStdNum courseStdNum = (CourseStdNum)courseStdNumMap.get(grade.getCourse());
                if (null == courseStdNum) {
                    courseStdNumMap.put(grade.getCourse(), new CourseStdNum(grade.getCourse(), new Integer(1)));
                    continue;
                }
                courseStdNum.setCount(new Integer(courseStdNum.getCount() + 1));
            }
        }
        this.stdGrades = new ArrayList(gradesMap.values());
        ArrayList courseStdNums = new ArrayList(courseStdNumMap.values());
        Collections.sort(courseStdNums);
        int maxStdCount = 0;
        if (CollectUtils.isNotEmpty(courseStdNums)) {
            maxStdCount = ((CourseStdNum)courseStdNums.get(0)).getCount();
        }
        this.courses = CollectUtils.newArrayList();
        for (int i = 0; i < courseStdNums.size(); ++i) {
            CourseStdNum rank = (CourseStdNum)courseStdNums.get(i);
            Float f = new Float(rank.getCount().intValue());
            if (!(f.floatValue() / (float)maxStdCount > ratio.floatValue())) continue;
            this.courses.add(rank.getCourse());
        }
        int maxExtra = 0;
        for (StdGrade stdGrade : this.stdGrades) {
            int myExtra = 0;
            List extraGrades = CollectUtils.newArrayList();
            HashSet<Course> commonCourseSet = new HashSet<Course>(this.courses);
            for (CourseGrade courseGrade : stdGrade.getGrades()) {
                if (commonCourseSet.contains(courseGrade.getCourse())) continue;
                extraGrades.add(courseGrade);
                ++myExtra;
            }
            if (myExtra > maxExtra) {
                maxExtra = myExtra;
            }
            if (extraGrades.isEmpty()) continue;
            this.extraGradeMap.put(((Long)stdGrade.getStd().getId()).toString(), extraGrades);
        }
        this.maxDisplay = new Integer(this.courses.size() + maxExtra);
    }

    public Squad getSquad() {
        return this.adminClass;
    }

    public void setSquad(Squad adminClass) {
        this.adminClass = adminClass;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public List<StdGrade> getStdGrades() {
        return this.stdGrades;
    }

    public void setStdGrades(List<StdGrade> stdGrades) {
        this.stdGrades = stdGrades;
    }

    public List getCourses() {
        return this.courses;
    }

    public void setCourses(List courseRankList) {
        this.courses = courseRankList;
    }

    public Integer getMaxDisplay() {
        return this.maxDisplay;
    }

    public void setMaxDisplay(Integer maxCourse) {
        this.maxDisplay = maxCourse;
    }

    public Float getRatio() {
        return this.ratio;
    }

    public void setRatio(Float ratio) {
        this.ratio = ratio;
    }

    public Map getExtraGradeMap() {
        return this.extraGradeMap;
    }

    public void setExtraGradeMap(Map extraGradeMap) {
        this.extraGradeMap = extraGradeMap;
    }

    public void sortStdGrades(String cmpWhat, boolean isAsc) {
        if (null != this.stdGrades) {
            PropertyComparator cmp = new PropertyComparator(cmpWhat, isAsc);
            Collections.sort(this.stdGrades, cmp);
        }
    }

    public int getExtraCourseNum() {
        return this.getMaxDisplay() - this.getCourses().size();
    }
}

