/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.setting.service.impl;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Project;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.service.CodeService;
import org.openurp.edu.grade.course.model.CourseGradeSetting;
import org.openurp.edu.grade.course.service.CourseGradeSettings;

public class CourseGradeSettingsImpl
extends BaseServiceImpl
implements CourseGradeSettings {
    private static final String COURSEGRADESETTING = "edu.grade.setting";
    private Map<Integer, CourseGradeSetting> cache = CollectUtils.newHashMap();
    private CodeService codeService;
    private ProjectPropertyService projectPropertyService;

    @Override
    public CourseGradeSetting getSetting(Project project) {
        String settingStr = this.projectPropertyService.get(project, COURSEGRADESETTING, "");
        CourseGradeSetting setting = null;
        if (Strings.isNotBlank((CharSequence)settingStr)) {
            Gson gson = new Gson();
            try {
                setting = (CourseGradeSetting)gson.fromJson(settingStr, CourseGradeSetting.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null == setting && (setting = this.cache.get(project.getId())) == null) {
            setting = new CourseGradeSetting(project);
            List<GradeType> allTypes = this.codeService.getCodes(GradeType.class);
            setting.getGaElementTypes().retainAll(allTypes);
            this.cache.put((Integer)project.getId(), setting);
        }
        return setting;
    }

    public void setCodeService(CodeService codeService) {
        this.codeService = codeService;
    }

    public void setProjectPropertyService(ProjectPropertyService projectPropertyService) {
        this.projectPropertyService = projectPropertyService;
    }
}

