/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.transcript.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.openurp.edu.grade.transcript.service.TranscriptDataProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringTranscriptDataProviderRegistry
implements ApplicationContextAware,
InitializingBean {
    final Map<String, TranscriptDataProvider> providers = CollectUtils.newHashMap();
    ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.applicationContext) {
            return;
        }
        String[] names = this.applicationContext.getBeanNamesForType(TranscriptDataProvider.class);
        if (null != names && names.length > 0) {
            for (String name : names) {
                this.providers.put(name, (TranscriptDataProvider)this.applicationContext.getBean(name));
            }
        }
    }

    public TranscriptDataProvider getProvider(String name) {
        return this.providers.get(name);
    }

    public List<TranscriptDataProvider> getProviders(String name) {
        if (Strings.isBlank((CharSequence)name)) {
            return Collections.emptyList();
        }
        String[] filterNames = Strings.split((String)name, (char[])new char[]{'|', ','});
        List myFilters = CollectUtils.newArrayList();
        for (String filterName : filterNames) {
            TranscriptDataProvider filter = this.providers.get(filterName);
            if (null == filter) continue;
            myFilters.add(filter);
        }
        return myFilters;
    }
}

