/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.edu.program.model.AbstractCoursePlan;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.StdPlan;
import org.openurp.edu.program.plan.service.CoursePlanProvider;

public class CoursePlanProviderImpl
extends BaseServiceImpl
implements CoursePlanProvider {
    @Override
    public ExecutivePlan getExecutivePlan(Student student) {
        ArrayList<ExecutivePlan> suitables;
        block9: {
            Program program;
            List plans;
            block8: {
                OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
                if (student.getState().getMajor() == null) {
                    return null;
                }
                query.where("plan.program.grade=:grade", (Object)student.getGrade());
                query.where("plan.program.level=:level", (Object)student.getLevel());
                query.where("plan.program.major=:major", (Object)student.getState().getMajor());
                ArrayList<Department> departs = new ArrayList<Department>();
                departs.add(student.getDepartment());
                if (null != student.getDepartment().getParent()) {
                    departs.add(student.getDepartment().getParent());
                }
                query.where("plan.program.department in(:departments)", departs);
                if (student.getState().getDirection() == null) {
                    query.where("plan.program.direction is null");
                } else {
                    query.where("plan.program.direction is null or plan.program.direction=:direction", (Object)student.getState().getDirection());
                }
                plans = this.entityDao.search((QueryBuilder)query);
                if (plans.isEmpty()) {
                    return null;
                }
                suitables = new ArrayList<ExecutivePlan>();
                if (null != student.getState().getDirection()) break block8;
                for (ExecutivePlan plan : plans) {
                    Program program2 = plan.getProgram();
                    if (!program2.getStdTypes().isEmpty() && !program2.getStdTypes().contains((Object)student.getStdType())) continue;
                    suitables.add(plan);
                }
                break block9;
            }
            for (ExecutivePlan plan : plans) {
                program = plan.getProgram();
                if (plan.getProgram().getDirection() == null || !program.getDirection().equals((Object)student.getState().getDirection()) || !program.getStdTypes().isEmpty() && !program.getStdTypes().contains((Object)student.getStdType())) continue;
                suitables.add(plan);
            }
            if (!suitables.isEmpty()) break block9;
            for (ExecutivePlan plan : plans) {
                program = plan.getProgram();
                if (program.getDirection() != null || !program.getStdTypes().isEmpty() && !program.getStdTypes().contains((Object)student.getStdType())) continue;
                suitables.add(plan);
            }
        }
        return suitables.isEmpty() ? null : (ExecutivePlan)suitables.get(0);
    }

    @Override
    public StdPlan getPersonalPlan(Student std) {
        OqlBuilder query = OqlBuilder.from(StdPlan.class, (String)"plan");
        query.where("plan.std = :std", (Object)std);
        return (StdPlan)this.entityDao.uniqueResult((QueryBuilder)query);
    }

    @Override
    public Map<Student, CoursePlan> getCoursePlans(Collection<Student> students) {
        Map result = CollectUtils.newHashMap();
        for (Student student : students) {
            CoursePlan plan = this.getCoursePlan(student);
            if (null == plan) continue;
            result.put(student, plan);
        }
        return result;
    }

    @Override
    public CoursePlan getCoursePlan(Student student) {
        AbstractCoursePlan plan = this.getPersonalPlan(student);
        if (null == plan) {
            plan = this.getExecutivePlan(student);
        }
        return plan;
    }

    @Override
    public List<PlanCourse> getPlanCourses(Student student) {
        CoursePlan plan = this.getCoursePlan(student);
        if (null == plan) {
            return CollectUtils.newArrayList();
        }
        Set planCourses = CollectUtils.newHashSet();
        this.addPlanCourse(plan.getGroups(), planCourses);
        return CollectUtils.newArrayList((Collection)planCourses);
    }

    private void addPlanCourse(List<CourseGroup> courseGroups, Set<PlanCourse> planCourses) {
        if (CollectionUtils.isEmpty(courseGroups)) {
            return;
        }
        for (CourseGroup courseGroup : courseGroups) {
            planCourses.addAll(courseGroup.getPlanCourses());
            this.addPlanCourse(courseGroup.getChildren(), planCourses);
        }
    }

    @Override
    public List<Semester> getSemesterByPlanCourse(PlanCourse planCourse) {
        Date beginOn = planCourse.getGroup().getPlan().getBeginOn();
        Date endOn = planCourse.getGroup().getPlan().getEndOn();
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester");
        builder.where("semester.beginOn <= :endOn", (Object)endOn);
        builder.where("semester.endOn >= :beginOn", (Object)beginOn);
        builder.orderBy(Order.parse((String)"semester.beginOn"));
        List semestersByInterval = this.entityDao.search((QueryBuilder)builder);
        List<Integer> terms = planCourse.getTerms().getTermList();
        List semestersByResult = CollectUtils.newArrayList();
        for (Integer term : terms) {
            semestersByResult.add((Semester)semestersByInterval.get(term - 1));
        }
        return semestersByResult;
    }
}

