/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.std.graduation.app.model;

import java.text.MessageFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Strings;
import org.openurp.base.std.model.Student;
import org.openurp.std.graduation.model.GraduateAuditItem;
import org.openurp.std.graduation.model.GraduateResult;

@Entity(name="org.openurp.std.graduation.app.model.GraduateAuditLog")
public class GraduateAuditLog
extends LongIdObject {
    private static final long serialVersionUID = -6428661513378861476L;
    @NotNull
    @Size(max=150)
    @Column(name="ssn")
    private String batch;
    @NotNull
    @Size(max=500)
    private String standardUsed;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @NotNull
    private String auditBy;
    @NotNull
    @Size(max=60)
    private String ip;
    @NotNull
    private Date operateAt;
    @NotNull
    private boolean passed;
    @Size(max=4000)
    private String detail;

    public GraduateAuditLog() {
    }

    public GraduateAuditLog(GraduateResult result) {
        this.std = result.getStd();
        this.passed = result.getPassed();
        this.batch = result.getBatch().getName();
        StringBuilder resultString = new StringBuilder();
        resultString.append(MessageFormat.format("\u6700\u7ec8\u7ed3\u679c\uff1a{0}", result.getPassed() != false ? "\u901a\u8fc7" : "\u672a\u901a\u8fc7"));
        resultString.append(MessageFormat.format("\n\u6bd5\u7ed3\u4e1a\u7ed3\u8bba\uff1a{0}", result.getEducationResult() == null ? "\u65e0" : result.getEducationResult().getName()));
        for (GraduateAuditItem resultItem : result.getItems()) {
            String passStr = "\u672a\u5ba1\u6838";
            if (resultItem.getPassed() != null && resultItem.getPassed().booleanValue()) {
                passStr = "\u5df2\u901a\u8fc7";
            }
            if (resultItem.getPassed() != null && !resultItem.getPassed().booleanValue()) {
                passStr = "\u672a\u901a\u8fc7";
            }
            resultString.append(MessageFormat.format("\r\n{0}\uff1a{1}", resultItem.getName(), passStr));
            if (!Strings.isNotBlank((CharSequence)resultItem.getComments())) continue;
            resultString.append("(").append(resultItem.getComments()).append(")");
        }
        if (Strings.isNotBlank((CharSequence)result.getComments())) {
            resultString.append("\r\n\u5907\u6ce8\uff1a").append(result.getComments());
        }
        this.detail = resultString.toString();
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public String getAuditBy() {
        return this.auditBy;
    }

    public void setAuditBy(String auditBy) {
        this.auditBy = auditBy;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public static long getSerialversionuid() {
        return -6428661513378861476L;
    }

    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Date getOperateAt() {
        return this.operateAt;
    }

    public void setOperateAt(Date operateAt) {
        this.operateAt = operateAt;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getStandardUsed() {
        return this.standardUsed;
    }

    public void setStandardUsed(String standardUsed) {
        this.standardUsed = standardUsed;
    }
}

