/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.std.graduation.app.model;

import java.sql.Date;
import java.util.Set;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.ems.rule.model.RuleConfig;
import org.openurp.base.std.model.StudentScope;

@Entity(name="org.openurp.std.graduation.app.model.GraduateAuditStandard")
public class GraduateAuditStandard
extends LongIdObject {
    public static final String BUSINESS_NAME = "Graduate Audit Standard";
    private static final long serialVersionUID = -815097740106060901L;
    @Size(max=500)
    @NotNull
    private String name;
    @Embedded
    @AssociationOverrides(value={@AssociationOverride(name="levels", joinTable=@JoinTable(name="GA_STANDARDS_EDUCATIONS", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="EDUCATION_ID", referencedColumnName="ID")})), @AssociationOverride(name="stdTypes", joinTable=@JoinTable(name="GA_STANDARDS_STD_TYPES", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="STD_TYPE_ID", referencedColumnName="ID")})), @AssociationOverride(name="departments", joinTable=@JoinTable(name="GA_STANDARDS_DEPARTMENTS", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="DEPARTMENT_ID", referencedColumnName="ID")})), @AssociationOverride(name="majors", joinTable=@JoinTable(name="GA_STANDARDS_MAJORS", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="MAJOR_ID", referencedColumnName="ID")})), @AssociationOverride(name="directions", joinTable=@JoinTable(name="GA_STANDARDS_DIRECTIONS", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="DIRECTION_ID", referencedColumnName="ID")}))})
    private StudentScope studentScope = new StudentScope();
    @NotNull
    private Date beginOn;
    private Date endOn;
    @ManyToMany
    @JoinTable(name="GA_STANDARDS_RULES", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="RULE_CONFIG_ID", referencedColumnName="ID")})
    private Set<RuleConfig> rules = CollectUtils.newHashSet();
    @ManyToMany
    @JoinTable(name="GA_STANDARDS_DEGREE_RULES", joinColumns={@JoinColumn(name="STANDARD_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="RULE_CONFIG_ID", referencedColumnName="ID")})
    private Set<RuleConfig> degreeRules = CollectUtils.newHashSet();
    @Size(max=600)
    private String remark;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public StudentScope getStudentScope() {
        return this.studentScope;
    }

    public void setStudentScope(StudentScope studentScope) {
        this.studentScope = studentScope;
    }

    public Set<RuleConfig> getRules() {
        return this.rules;
    }

    public void setRules(Set<RuleConfig> rules) {
        this.rules = rules;
    }

    public Set<RuleConfig> getDegreeRules() {
        return this.degreeRules;
    }

    public void setDegreeRules(Set<RuleConfig> degreeRules) {
        this.degreeRules = degreeRules;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }
}

