/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.util;

import org.beangle.commons.text.seq.HanZiSeqStyle;

public class LuomaSeqStyle
extends HanZiSeqStyle {
    public static final int MAX = 99999;
    public static final String[][] levels = new String[][]{{"I", "V", "X"}, {"X", "L", "C"}, {"C", "D", "M"}};

    public String buildText(String f) {
        String n = f;
        if (!this.isNuneric(n)) {
            for (int c = 0; c < n.length(); ++c) {
                char chr = n.toLowerCase().charAt(c);
                if (!(chr != 'i' & chr != 'v' & chr != 'x' & chr != 'l' & chr != 'c' & chr != 'd' & chr != 'm')) continue;
                return null;
            }
        }
        n = this.toRoman(f);
        return n;
    }

    public String toRoman(String n) {
        Object r = "";
        for (int c = 0; c < n.length(); ++c) {
            r = (String)r + this.calcDigit(Integer.parseInt("" + n.charAt(c)), n.length() - c - 1);
        }
        return r;
    }

    public String calcDigit(Integer d, int l) {
        if (l > 2) {
            Object str = "";
            int m = 1;
            while ((double)m <= (double)d.intValue() * Math.pow(10.0, l - 3)) {
                str = (String)str + "M";
                ++m;
            }
            return str;
        }
        if (d == 1) {
            return levels[l][0];
        }
        if (d == 2) {
            return levels[l][0] + levels[l][0];
        }
        if (d == 3) {
            return levels[l][0] + levels[l][0] + levels[l][0];
        }
        if (d == 4) {
            return levels[l][0] + levels[l][1];
        }
        if (d == 5) {
            return levels[l][1];
        }
        if (d == 6) {
            return levels[l][1] + levels[l][0];
        }
        if (d == 7) {
            return levels[l][1] + levels[l][0] + levels[l][0];
        }
        if (d == 8) {
            return levels[l][1] + levels[l][0] + levels[l][0] + levels[l][0];
        }
        if (d == 9) {
            return levels[l][0] + levels[l][2];
        }
        return "";
    }

    public boolean isNuneric(String str) {
        for (int c = 0; c < str.length(); ++c) {
            char chr = str.charAt(c);
            if (!(chr != '0' & chr != '1' & chr != '2' & chr != '3' & chr != '4' & chr != '5' & chr != '6' & chr != '7' & chr != '8' & chr != '9')) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        LuomaSeqStyle luomaSeqStyle = new LuomaSeqStyle();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(luomaSeqStyle.buildText(String.valueOf(i + 1)));
        }
    }
}

