/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.util.stat;

import java.util.ArrayList;
import java.util.List;
import org.beangle.commons.lang.Objects;

public class FloatSegment
implements Comparable<Object> {
    float min;
    float max;
    int count;

    public FloatSegment() {
        this(0.0f, 0.0f);
    }

    public FloatSegment(float min, float max) {
        this.min = min;
        this.max = max;
        this.count = 0;
    }

    public boolean add(Float score) {
        return this.add(score.floatValue());
    }

    public boolean add(float score) {
        if (score <= this.max && score >= this.min) {
            ++this.count;
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public int compareTo(Object object) {
        FloatSegment myClass = (FloatSegment)object;
        return Float.compare(myClass.getMin(), this.getMin());
    }

    public Object clone() {
        return new FloatSegment(this.getMin(), this.getMax());
    }

    public boolean emptySeg() {
        return this.min == 0.0f && this.max == 0.0f;
    }

    public String toString() {
        return Objects.toStringBuilder(this.getClass()).add("min", (Object)Float.valueOf(this.getMin())).add("max", (Object)Float.valueOf(this.getMax())).add("count", (Object)this.count).toString();
    }

    public static List<FloatSegment> buildSegments(int start, int level, int count) {
        ArrayList<FloatSegment> segmentList = new ArrayList<FloatSegment>();
        for (int i = 0; i < count; ++i) {
            segmentList.add(new FloatSegment(start, start + level - 1));
            start += level;
        }
        return segmentList;
    }

    public static void countSegments(List<FloatSegment> segs, List<Number> numbers) {
        for (Number number : numbers) {
            if (null == number) continue;
            for (FloatSegment element : segs) {
                if (element.add(number.floatValue())) break;
            }
        }
    }
}

