/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.limit.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.lang.Arrays;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.service.ProjectContext;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.service.limit.impl.AbstractCourseLimitContentProvider;

public abstract class AbstractCourseLimitEntityProvider<T extends Entity<?>>
extends AbstractCourseLimitContentProvider<T> {
    protected ProjectContext projectContext;

    @Override
    protected Map<String, T> getContentMap(Object[] content) {
        List entities = this.entityDao.get(this.getMeta().getContentType().getName(), "id", content);
        LinkedHashMap<String, Entity> results = new LinkedHashMap<String, Entity>();
        for (Entity entity : entities) {
            results.put(entity.getId().toString(), entity);
        }
        return results;
    }

    public OqlBuilder<T> getQueryBuilder(Object[] content, String term, PageLimit limit) {
        OqlBuilder queryBuilder = OqlBuilder.from((String)this.getMeta().getContentType().getName(), (String)"entity");
        if (!Arrays.isEmpty((Object[])content)) {
            queryBuilder.where("entity.id not in(:ids)", (Object)content);
        }
        if (null != term) {
            this.addTermCondition(queryBuilder, term);
        }
        queryBuilder.orderBy("id");
        queryBuilder.limit(limit);
        return queryBuilder;
    }

    @Override
    protected List<T> getCascadeContents(Object[] content, String term, PageLimit limit, Map<ClazzRestrictionMeta, String> cascadeField) {
        OqlBuilder<T> builder = this.getQueryBuilder(content, term, limit);
        this.addCascadeQuery(builder, cascadeField);
        return this.entityDao.search(builder);
    }

    protected void addCascadeQuery(OqlBuilder<T> builder, Map<ClazzRestrictionMeta, String> cascadeField) {
    }

    @Override
    protected List<T> getOtherContents(Object[] content, String term, PageLimit limit) {
        return this.entityDao.search(this.getQueryBuilder(content, term, limit));
    }

    protected void addTermCondition(OqlBuilder<T> queryBuilder, String term) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = false;
        try {
            if (String.class.isAssignableFrom(Model.getType(this.getMeta().getContentType()).getPropertyType("name").getReturnedClass())) {
                sb.append("entity.name like :codeOrName ");
                hasName = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (String.class.isAssignableFrom(Model.getType(this.getMeta().getContentType()).getPropertyType("code").getReturnedClass())) {
                if (hasName) {
                    sb.append("or ");
                }
                sb.append("entity.code like :codeOrName ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sb.length() > 0) {
            queryBuilder.where(sb.toString(), (Object)("%" + term + "%"));
        }
    }

    @Override
    public Map<String, String> getContentIdTitleMap(String content) {
        List entities = this.entityDao.get(this.getMeta().getContentType().getName(), "id", this.getContentValues(content));
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (Entity entity : entities) {
            Pair<String, String> idTitle = this.getContentIdTitle(entity);
            results.put((String)idTitle.getLeft(), (String)idTitle.getRight());
        }
        return results;
    }

    public Pair<String, String> getContentIdTitle(T entity) {
        try {
            String name = null;
            try {
                name = (String)PropertyUtils.getProperty(entity, (String)"shortName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == name) {
                name = (String)PropertyUtils.getProperty(entity, (String)"name");
            }
            return new Pair((Object)entity.getId().toString(), (Object)name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setProjectContext(ProjectContext projectContext) {
        this.projectContext = projectContext;
    }
}

