/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryPage;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.plan.service.AbstractJob;
import org.openurp.edu.grade.plan.service.PlanAuditService;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserverStack;
import org.openurp.edu.grade.plan.service.observers.PlanAuditPersistObserver;

public class AutoBatchAuditor
extends AbstractJob {
    private PlanAuditService planAuditService;
    private PlanAuditPersistObserver planAuditPersistObserver;
    private int bulkSize = 300;

    @Override
    protected void doExecute() {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"s");
        query.where("s.state.inschool=true");
        query.where("s.beginOn <= :now and s.endOn >= :now", (Object)new Date());
        query.orderBy("s.code");
        QueryPage page = new QueryPage(query, this.entityDao);
        query.limit(1, this.bulkSize);
        long startAt = System.currentTimeMillis();
        this.logger.info("start auto gew ...");
        List stds = CollectUtils.newArrayList();
        Iterator stdIter = page.iterator();
        while (stdIter.hasNext()) {
            int i = 0;
            while (stdIter.hasNext() && i < this.bulkSize) {
                stds.add((Student)stdIter.next());
            }
            PlanAuditObserverStack observerStack = new PlanAuditObserverStack(this.planAuditPersistObserver);
            this.planAuditService.batchAudit(stds, null, observerStack, null);
            this.logger.info("auto gew: " + ((Student)stds.get(0)).getCode() + "~" + ((Student)stds.get(stds.size() - 1)).getCode() + "[" + stds.size() + "] using " + (double)(System.currentTimeMillis() - startAt) / 1000.0 + "s");
        }
        this.logger.info("auto gew: all result is updated today!");
    }

    public int getBulkSize() {
        return this.bulkSize;
    }

    public void setBulkSize(int bulkSize) {
        this.bulkSize = bulkSize;
    }

    public void setPlanAuditService(PlanAuditService planAuditService) {
        this.planAuditService = planAuditService;
    }

    public void setPlanAuditPersistObserver(PlanAuditPersistObserver planAuditPersistObserver) {
        this.planAuditPersistObserver = planAuditPersistObserver;
    }
}

