/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.app.model.AuditSetting;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.CourseGradeProvider;
import org.openurp.edu.grade.plan.adapters.CourseGroupAdapter;
import org.openurp.edu.grade.plan.adapters.GroupResultAdapter;
import org.openurp.edu.grade.plan.model.AuditCourseResult;
import org.openurp.edu.grade.plan.model.AuditGroupResult;
import org.openurp.edu.grade.plan.model.AuditPlanResult;
import org.openurp.edu.grade.plan.model.AuditStat;
import org.openurp.edu.grade.plan.service.AuditPlanContext;
import org.openurp.edu.grade.plan.service.AuditPlanListener;
import org.openurp.edu.grade.plan.service.AuditSettingService;
import org.openurp.edu.grade.plan.service.PlanAuditService;
import org.openurp.edu.grade.plan.service.internal.DefaultGroupResultBuilder;
import org.openurp.edu.grade.plan.service.internal.GroupResultBuilder;
import org.openurp.edu.grade.plan.service.internal.StdGradeImpl;
import org.openurp.edu.grade.plan.service.observers.ObserverUtils;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserverStack;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.service.CoursePlanProvider;
import org.openurp.edu.program.utils.PlanUtils;
import org.openurp.service.OutputObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditPlanServiceImpl
extends BaseServiceImpl
implements PlanAuditService {
    private Logger logger = LoggerFactory.getLogger(AuditPlanServiceImpl.class);
    protected CoursePlanProvider coursePlanProvider;
    protected AuditSettingService auditSettingService;
    protected CourseGradeProvider courseGradeProvider;
    protected GroupResultBuilder groupResultBuilder = new DefaultGroupResultBuilder();
    protected List<AuditPlanListener> listeners = new ArrayList<AuditPlanListener>();

    @Override
    public AuditPlanResult audit(Student student) {
        CoursePlan plan = this.coursePlanProvider.getCoursePlan(student);
        AuditSetting setting = this.auditSettingService.getSetting(student);
        if (setting.isTransient() && null != plan && null != plan.getProgram().getOffsetType()) {
            setting.setConvertTarget(plan.getProgram().getOffsetType());
        }
        AuditPlanContext context = new AuditPlanContext(student, plan, setting);
        return this.audit(student, context);
    }

    @Override
    public AuditPlanResult audit(Student student, AuditPlanContext context) {
        this.logger.debug("start audit {}", (Object)student.getCode());
        AuditPlanResult planAuditResult = new AuditPlanResult(student);
        planAuditResult.setPassed(false);
        planAuditResult.setRemark(null);
        planAuditResult.setUpdatedAt(new Date());
        planAuditResult.setAuditStat(new AuditStat());
        context.setResult(planAuditResult);
        CoursePlan plan = context.getCoursePlan();
        if (null == plan) {
            planAuditResult.setRemark("\u6ca1\u6709\u5339\u914d\u7684\u57f9\u517b\u8ba1\u5212");
            return context.getResult();
        }
        context.setStdGrade(new StdGradeImpl(this.courseGradeProvider.getPublished(student, new Semester[0])));
        for (AuditPlanListener listener : this.listeners) {
            if (listener.startPlanAudit(context)) continue;
            return planAuditResult;
        }
        CourseGroupAdapter courseGroupAdapter = new CourseGroupAdapter(context.getCoursePlan());
        GroupResultAdapter groupResultAdapter = new GroupResultAdapter(planAuditResult);
        float requiredCredits = context.getCoursePlan().getCredits();
        if (context.getAuditTerms() != null && context.getAuditTerms().length != 0) {
            requiredCredits = 0.0f;
            for (int i = 0; i < context.getAuditTerms().length; ++i) {
                for (CourseGroup group : context.getCoursePlan().getGroups()) {
                    if (group.getParent() != null) continue;
                    requiredCredits += PlanUtils.getGroupCredits(group, Integer.valueOf(context.getAuditTerms()[i]));
                }
            }
        }
        planAuditResult.getAuditStat().setRequiredCredits(requiredCredits);
        this.auditGroup(context, courseGroupAdapter, groupResultAdapter);
        for (AuditPlanListener listener : this.listeners) {
            listener.endPlanAudit(context);
        }
        AuditGroupResult lastTarget = context.getResult().getGroupResult(context.getSetting().getConvertTarget());
        if (null != lastTarget && lastTarget.getAuditStat().getPassedCredits() == 0.0f && lastTarget.getAuditStat().getRequiredCredits() == 0.0f && lastTarget.getCourseResults().isEmpty()) {
            context.getResult().removeGroupResult(lastTarget);
        }
        return planAuditResult;
    }

    private void auditGroup(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult groupAuditResult) {
        List<CourseGroup> courseGroups = courseGroup.getChildren();
        AuditPlanResult planAuditResult = context.getResult();
        block0: for (CourseGroup children : courseGroups) {
            AuditGroupResult childResult = this.groupResultBuilder.buildResult(context, children);
            groupAuditResult.addChild(childResult);
            planAuditResult.addGroupResult(childResult);
            for (AuditPlanListener listener : this.listeners) {
                if (listener.startGroupAudit(context, children, childResult)) continue;
                planAuditResult.getAuditStat().reduceRequired(childResult.getAuditStat().getRequiredCredits());
                groupAuditResult.removeChild(childResult);
                planAuditResult.removeGroupResult(childResult);
                continue block0;
            }
            this.auditGroup(context, children, childResult);
        }
        List<PlanCourse> myPlanCourses = courseGroup.getPlanCourses();
        block2: for (PlanCourse planCourse : myPlanCourses) {
            for (AuditPlanListener listener : this.listeners) {
                if (listener.startCourseAudit(context, groupAuditResult, planCourse)) continue;
                continue block2;
            }
            AuditCourseResult planCourseAuditResult = new AuditCourseResult(planCourse);
            List<CourseGrade> courseGrades = context.getStdGrade().useGrades(planCourse.getCourse());
            if (courseGrades.isEmpty()) {
                if (!planCourse.isCompulsory() && !courseGroup.isAutoAddup()) continue;
                courseGrades = Collections.emptyList();
            }
            planCourseAuditResult.checkPassed(courseGrades);
            groupAuditResult.addCourseResult(planCourseAuditResult);
        }
        groupAuditResult.checkPassed(false);
    }

    @Override
    public AuditPlanResult getResult(Student std) {
        OqlBuilder query = OqlBuilder.from(AuditPlanResult.class, (String)"planResult");
        query.where("planResult.std = :std", (Object)std);
        List results = this.entityDao.search((QueryBuilder)query);
        if (results.size() > 0) {
            return (AuditPlanResult)((Object)results.get(0));
        }
        return null;
    }

    @Override
    public void batchAudit(Collection<Student> stds, String[] auditTerms, PlanAuditObserverStack observerStack, OutputObserver weboutput) {
        observerStack.notifyStart();
        int amount = stds.size();
        String msg = MessageFormat.format("{0} \u4f4d\u5b66\u751f\u8ba1\u5212\u5b8c\u6210\u5ba1\u6838", amount);
        ObserverUtils.notifyStart(weboutput, msg, amount, null);
        int count = 0;
        Iterator<Student> iterator = stds.iterator();
        while (iterator.hasNext()) {
            Student student = iterator.next();
            CoursePlan plan = this.coursePlanProvider.getCoursePlan(student);
            AuditSetting setting = this.auditSettingService.getSetting(student);
            if (setting.isTransient() && null != plan && null != plan.getProgram().getOffsetType()) {
                setting.setConvertTarget(plan.getProgram().getOffsetType());
            }
            AuditPlanContext context = new AuditPlanContext(student, plan, setting);
            context.getParams().put("_weboutput", weboutput);
            context.setAuditTerms(auditTerms);
            if (null == context.getCoursePlan()) {
                msg = MessageFormat.format("\u65e0\u6cd5\u627e\u5230 {0} {1} \u7684\u57f9\u517b\u8ba1\u5212\uff0c\u5ba1\u6838\u5931\u8d25\u3002", student.getName(), student.getCode());
                if (observerStack.notifyBegin(context, count)) {
                    this.audit(student, context);
                    observerStack.notifyEnd(context, count);
                }
                ObserverUtils.outputMessage(context, 3, msg, true);
            } else {
                Object auditTermsStr = "";
                if (auditTerms != null && auditTerms.length > 0) {
                    auditTermsStr = "(\u7b2c" + Strings.join((String[])auditTerms, (String)",") + "\u5b66\u671f)";
                }
                msg = MessageFormat.format("\u5f00\u59cb\u5ba1\u6838 {0} {1} \u7684\u8ba1\u5212\u5b8c\u6210\u60c5\u51b5{2}", student.getName(), student.getCode(), auditTermsStr);
                ObserverUtils.outputMessage(context, 1, msg, true);
                if (observerStack.notifyBegin(context, count)) {
                    this.audit(student, context);
                    observerStack.notifyEnd(context, count);
                }
                msg = MessageFormat.format("\u5ba1\u6838\u5b8c\u6bd5 {0} {1} \u7684\u8ba1\u5212\u5b8c\u6210\u60c5\u51b5", student.getName(), student.getCode());
                ObserverUtils.outputMessage(context, 1, msg, false);
            }
            if (iterator.hasNext()) {
                ObserverUtils.delimiter(weboutput);
            }
            ++count;
        }
        observerStack.finish();
    }

    @Override
    public AuditSetting getSetting(Student student) {
        return this.auditSettingService.getSetting(student);
    }

    public void setCoursePlanProvider(CoursePlanProvider coursePlanProvider) {
        this.coursePlanProvider = coursePlanProvider;
    }

    public void setCourseGradeProvider(CourseGradeProvider courseGradeProvider) {
        this.courseGradeProvider = courseGradeProvider;
    }

    public List<AuditPlanListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<AuditPlanListener> listeners) {
        this.listeners = listeners;
    }

    public void setGroupResultBuilder(GroupResultBuilder groupResultBuilder) {
        this.groupResultBuilder = groupResultBuilder;
    }

    public void setAuditSettingService(AuditSettingService auditSettingService) {
        this.auditSettingService = auditSettingService;
    }
}

